"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformDashboardIn = void 0;
var _common = require("@kbn/saved-objects-tagging-plugin/common");
var _transform_panels_in = require("./transform_panels_in");
var _transform_control_group_in = require("./transform_control_group_in");
var _transform_search_source_in = require("./transform_search_source_in");
var _transform_tags_in = require("./transform_tags_in");
var _transform_options_in = require("./transform_options_in");
var _transform_references_out = require("../out/transform_references_out");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const transformDashboardIn = dashboardState => {
  try {
    const {
      controlGroupInput,
      options,
      filters,
      panels,
      query,
      references: incomingReferences,
      tags,
      time_range,
      refresh_interval,
      project_routing,
      ...rest
    } = dashboardState;

    // TODO remove when references are removed from API
    const hasTagReference = (incomingReferences !== null && incomingReferences !== void 0 ? incomingReferences : []).some(({
      type
    }) => type === _common.tagSavedObjectTypeName);
    if (hasTagReference) {
      throw new Error(`Tag references are not supported. Pass tags in with 'data.tags'`);
    }
    // TODO remove when references are removed from API
    const hasSearchSourceReference = (incomingReferences !== null && incomingReferences !== void 0 ? incomingReferences : []).some(_transform_references_out.isSearchSourceReference);
    if (hasSearchSourceReference) {
      throw new Error(`Search source references are not supported. Pass filters in with injected references'`);
    }
    const tagReferences = (0, _transform_tags_in.transformTagsIn)(tags);
    const {
      panelsJSON,
      sections,
      references: panelReferences
    } = panels ? (0, _transform_panels_in.transformPanelsIn)(panels) : {
      panelsJSON: '',
      sections: undefined,
      references: []
    };
    const {
      searchSourceJSON,
      references: searchSourceReferences
    } = (0, _transform_search_source_in.transformSearchSourceIn)(filters, query);
    const attributes = {
      description: '',
      ...rest,
      ...(controlGroupInput && {
        controlGroupInput: (0, _transform_control_group_in.transformControlGroupIn)(controlGroupInput)
      }),
      optionsJSON: (0, _transform_options_in.transformOptionsIn)(options),
      panelsJSON,
      ...(refresh_interval && {
        refreshInterval: refresh_interval
      }),
      ...((sections === null || sections === void 0 ? void 0 : sections.length) && {
        sections
      }),
      ...(time_range ? {
        timeFrom: time_range.from,
        timeTo: time_range.to,
        timeRestore: true
      } : {
        timeRestore: false
      }),
      kibanaSavedObjectMeta: {
        searchSourceJSON
      },
      ...(project_routing !== undefined && {
        projectRouting: project_routing
      })
    };
    return {
      attributes,
      references: [...tagReferences, ...(incomingReferences !== null && incomingReferences !== void 0 ? incomingReferences : []), ...panelReferences, ...searchSourceReferences],
      error: null
    };
  } catch (e) {
    return {
      attributes: null,
      references: null,
      error: e
    };
  }
};
exports.transformDashboardIn = transformDashboardIn;