"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _create = require("./create");
var _update = require("./update");
var _delete = require("./delete");
var _search = require("./search");
var _read = require("./read");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerRoutes(http) {
  const {
    versioned: versionedRouter
  } = http.createRouter();
  (0, _create.registerCreateRoute)(versionedRouter);
  (0, _read.registerReadRoute)(versionedRouter);
  (0, _update.registerUpdateRoute)(versionedRouter);
  (0, _delete.registerDeleteRoute)(versionedRouter);
  (0, _search.registerSearchRoute)(versionedRouter);
}