"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardAgentPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _register_agent = require("./register_agent");
var _tools = require("./tools");
var _get_is_dashboard_agent_enabled = require("./utils/get_is_dashboard_agent_enabled");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DashboardAgentPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, setupDeps) {
    this.logger.debug('Setting up Dashboard Agent plugin');
    (0, _get_is_dashboard_agent_enabled.getIsDashboardAgentEnabled)(coreSetup).then(isDashboardAgentEnabled => {
      if (!isDashboardAgentEnabled) {
        this.logger.debug(`Skipping dashboard agent registration because feature flag "${_constants.DASHBOARD_AGENT_FEATURE_FLAG}" is set to false`);
        return;
      }
      this.registerToolsAndAgent(coreSetup, setupDeps).catch(error => {
        this.logger.error(`Error registering dashboard agent and tools: ${error}`);
      });
    }).catch(error => {
      this.logger.error(`Error checking whether the dashboard agent is enabled: ${error}`);
    });
    return {};
  }
  async registerToolsAndAgent(coreSetup, setupDeps) {
    var _startDeps$share, _startDeps$share$url, _startDeps$share$url$;
    const [coreStart, startDeps] = await coreSetup.getStartServices();
    const dashboardLocator = (_startDeps$share = startDeps.share) === null || _startDeps$share === void 0 ? void 0 : (_startDeps$share$url = _startDeps$share.url) === null || _startDeps$share$url === void 0 ? void 0 : (_startDeps$share$url$ = _startDeps$share$url.locators) === null || _startDeps$share$url$ === void 0 ? void 0 : _startDeps$share$url$.get('DASHBOARD_APP_LOCATOR');
    if (!dashboardLocator) {
      this.logger.warn('Dashboard locator is unavailable; skipping dashboard tool registration.');
      return;
    }
    setupDeps.onechat.tools.register((0, _tools.createDashboardTool)(startDeps.dashboard, coreStart.savedObjects, {
      dashboardLocator,
      spaces: startDeps.spaces
    }));
    setupDeps.onechat.tools.register((0, _tools.updateDashboardTool)(startDeps.dashboard, coreStart.savedObjects, {
      dashboardLocator,
      spaces: startDeps.spaces
    }));

    // Register the dashboard agent
    (0, _register_agent.registerDashboardAgent)(setupDeps.onechat);
  }
  start(_coreStart, _startDeps) {
    return {};
  }
  stop() {}
}
exports.DashboardAgentPlugin = DashboardAgentPlugin;