"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHttpService = exports.createCoreContext = exports.createConfigService = void 0;
var _rxjs = require("rxjs");
var _moment = _interopRequireDefault(require("moment"));
var _repoInfo = require("@kbn/repo-info");
var _configSchema = require("@kbn/config-schema");
var _config = require("@kbn/config");
var _configMocks = require("@kbn/config-mocks");
var _coreHttpContextServerMocks = require("@kbn/core-http-context-server-mocks");
var _coreDocLinksServerMocks = require("@kbn/core-doc-links-server-mocks");
var _coreExecutionContextServerMocks = require("@kbn/core-execution-context-server-mocks");
var _coreLoggingServerMocks = require("@kbn/core-logging-server-mocks");
var _coreHttpServerInternal = require("@kbn/core-http-server-internal");
var _lazyObject = require("@kbn/lazy-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const coreId = Symbol('core');
const env = _config.Env.createDefault(_repoInfo.REPO_ROOT, (0, _configMocks.getEnvOptions)());
const logger = _coreLoggingServerMocks.loggingSystemMock.create();
const createConfigService = ({
  server,
  externalUrl,
  csp
} = {}) => {
  const configService = _configMocks.configServiceMock.create();
  configService.atPath.mockImplementation(path => {
    if (path === 'server') {
      return new _rxjs.BehaviorSubject(Object.assign(_coreHttpServerInternal.config.schema.validate({}), {
        name: 'kibana',
        hosts: ['localhost'],
        maxPayload: new _configSchema.ByteSizeValue(1024),
        autoListen: true,
        ssl: {
          enabled: false
        },
        cors: {
          enabled: false
        },
        compression: {
          enabled: true,
          brotli: {
            enabled: false
          }
        },
        xsrf: {
          disableProtection: true,
          allowlist: []
        },
        securityResponseHeaders: {},
        customResponseHeaders: {},
        requestId: {
          allowFromAnyIp: true,
          ipAllowlist: []
        },
        shutdownTimeout: _moment.default.duration(30, 'seconds'),
        keepaliveTimeout: 120_000,
        socketTimeout: 120_000,
        restrictInternalApis: false,
        // disable restriction for Kibana tests
        versioned: {
          versionResolution: 'oldest',
          strictClientVersionCheck: true
        }
      }, server));
    }
    if (path === 'externalUrl') {
      return new _rxjs.BehaviorSubject({
        policy: [],
        ...externalUrl
      });
    }
    if (path === 'csp') {
      return new _rxjs.BehaviorSubject({
        strict: false,
        disableEmbedding: false,
        warnLegacyBrowsers: true,
        ...csp
      });
    }
    if (path === 'permissionsPolicy') {
      return new _rxjs.BehaviorSubject({
        report_to: []
      });
    }
    if (path === 'pricing') {
      return new _rxjs.BehaviorSubject({
        tiers: {
          enabled: true,
          products: []
        }
      });
    }
    throw new Error(`Unexpected config path: ${path}`);
  });
  return configService;
};
exports.createConfigService = createConfigService;
const createDefaultContext = () => {
  return (0, _lazyObject.createLazyObjectFromAnnotations)({
    "coreId": (0, _lazyObject.annotateLazy)(() => coreId),
    "env": (0, _lazyObject.annotateLazy)(() => env),
    "logger": (0, _lazyObject.annotateLazy)(() => logger),
    "configService": (0, _lazyObject.annotateLazy)(() => createConfigService())
  });
};
const createCoreContext = (overrides = {}) => (0, _lazyObject.createLazyObjectFromAnnotations)({
  ...createDefaultContext(),
  ...overrides
});

/**
 * A mock of the HttpService that can be used in tests.
 *
 * @remarks intended to mirror the pubilc HTTP contracts where possible to avoid
 *          drifting or leaking too many internal details of the actual HttpService.
 */
exports.createCoreContext = createCoreContext;
/**
 * Creates an HTTP service instance for external services to test against.
 * @public
 */
const createHttpService = () => {
  const ctx = createCoreContext();
  const svc = new _coreHttpServerInternal.HttpService(ctx);
  return {
    preboot: async () => {
      await svc.preboot({
        context: _coreHttpContextServerMocks.contextServiceMock.createPrebootContract(),
        docLinks: _coreDocLinksServerMocks.docLinksServiceMock.createSetupContract()
      });
    },
    setup: () => {
      return svc.setup({
        context: _coreHttpContextServerMocks.contextServiceMock.createSetupContract(),
        executionContext: _coreExecutionContextServerMocks.executionContextServiceMock.createInternalSetupContract()
      });
    },
    start: async () => {
      await svc.start();
    },
    stop: async () => {
      await svc.stop();
    }
  };
};
exports.createHttpService = createHttpService;