"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCreateRestAPIKeyParams = isCreateRestAPIKeyParams;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Interface for managing API keys in Elasticsearch, including creation,
 * validation, and invalidation of API keys,
 * as well as checking the status of API key features.
 */

/**
 * Response of Kibana Create API key endpoint.
 */

/**
 * Represents the parameters for validating API Key credentials.
 */

/**
 * Represents the params for invalidating multiple API keys
 */

/**
 * The return value when invalidating an API key in Elasticsearch.
 */

/**
 * Response of Kibana Update API key endpoint.
 */

/**
 * Request body of Kibana Update API key endpoint.
 */

function isCreateRestAPIKeyParams(params) {
  return 'role_descriptors' in params;
}