"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelStageMap = exports.model = void 0;
var Either = _interopRequireWildcard(require("fp-ts/Either"));
var _retry_state = require("../../model/retry_state");
var _helpers = require("../../model/helpers");
var _actions = require("../actions");
var Stages = _interopRequireWildcard(require("./stages"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const modelStageMap = exports.modelStageMap = {
  INIT: Stages.init,
  CREATE_TARGET_INDEX: Stages.createTargetIndex,
  UPDATE_ALIASES: Stages.updateAliases,
  UPDATE_INDEX_MAPPINGS: Stages.updateIndexMappings,
  UPDATE_INDEX_MAPPINGS_WAIT_FOR_TASK: Stages.updateIndexMappingsWaitForTask,
  UPDATE_MAPPING_MODEL_VERSIONS: Stages.updateMappingModelVersion,
  INDEX_STATE_UPDATE_DONE: Stages.indexStateUpdateDone,
  DOCUMENTS_UPDATE_INIT: Stages.documentsUpdateInit,
  SET_DOC_MIGRATION_STARTED: Stages.setDocMigrationStarted,
  SET_DOC_MIGRATION_STARTED_WAIT_FOR_INSTANCES: Stages.setDocMigrationStartedWaitForInstances,
  CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS: Stages.cleanupUnknownAndExcludedDocs,
  CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS_WAIT_FOR_TASK: Stages.cleanupUnknownAndExcludedDocsWaitForTask,
  CLEANUP_UNKNOWN_AND_EXCLUDED_DOCS_REFRESH: Stages.cleanupUnknownAndExcludedDocsRefresh,
  OUTDATED_DOCUMENTS_SEARCH_OPEN_PIT: Stages.outdatedDocumentsSearchOpenPit,
  OUTDATED_DOCUMENTS_SEARCH_READ: Stages.outdatedDocumentsSearchRead,
  OUTDATED_DOCUMENTS_SEARCH_TRANSFORM: Stages.outdatedDocumentsSearchTransform,
  OUTDATED_DOCUMENTS_SEARCH_BULK_INDEX: Stages.outdatedDocumentsSearchBulkIndex,
  OUTDATED_DOCUMENTS_SEARCH_CLOSE_PIT: Stages.outdatedDocumentsSearchClosePit,
  OUTDATED_DOCUMENTS_SEARCH_REFRESH: Stages.outdatedDocumentsSearchRefresh,
  UPDATE_DOCUMENT_MODEL_VERSIONS: Stages.updateDocumentModelVersion,
  UPDATE_DOCUMENT_MODEL_VERSIONS_WAIT_FOR_INSTANCES: Stages.updateDocumentModelVersionWaitForInstances
};
const model = (current, response, context) => {
  if (Either.isLeft(response)) {
    if ((0, _actions.isTypeof)(response.left, 'retryable_es_client_error')) {
      return (0, _retry_state.delayRetryState)(current, response.left.message, context.maxRetryAttempts);
    }
  } else {
    current = (0, _retry_state.resetRetryState)(current);
  }
  if (current.controlState === 'DONE' || current.controlState === 'FATAL') {
    return (0, _helpers.throwBadControlState)(current);
  }
  const stageHandler = modelStageMap[current.controlState];
  if (!stageHandler) {
    return (0, _helpers.throwBadControlState)(current);
  }
  return stageHandler(current, response, context);
};
exports.model = model;