"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexDocuments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _public = require("@kbn/kibana-react-plugin/public");
var _api = require("../../../common/types/api");
var _mappings_logic = require("../../api/mappings/mappings_logic");
var _index_name_logic = require("./index_name_logic");
var _index_view_logic = require("./index_view_logic");
var _access_control_index_selector = require("./access_control_index_selector/access_control_index_selector");
var _search_documents_api_logic = require("../../api/search_documents/search_documents_api_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/documents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGINATION = {
  pageIndex: _searchIndexDocuments.INDEX_DOCUMENTS_META_DEFAULT.pageIndex,
  pageSize: _searchIndexDocuments.INDEX_DOCUMENTS_META_DEFAULT.pageSize,
  totalItemCount: _searchIndexDocuments.INDEX_DOCUMENTS_META_DEFAULT.totalItemCount
};
const SearchIndexDocuments = () => {
  var _data$results, _error$body, _pagination$pageSize2, _data$meta;
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    ingestionMethod,
    hasDocumentLevelSecurityFeature
  } = (0, _kea.useValues)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  const [selectedIndexType, setSelectedIndexType] = (0, _react.useState)('content-index');
  const indexToShow = selectedIndexType === 'content-index' ? indexName : `${_searchConnectors.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX}${indexName}`;
  const mappingLogic = (0, _mappings_logic.mappingsWithPropsApiLogic)(indexToShow);
  const documentLogic = (0, _search_documents_api_logic.searchDocumentsApiLogic)(indexToShow);
  const {
    makeRequest: getDocuments
  } = (0, _kea.useActions)(documentLogic);
  const {
    makeRequest: getMappings
  } = (0, _kea.useActions)(mappingLogic);
  const {
    data,
    status,
    error
  } = (0, _kea.useValues)(documentLogic);
  const {
    data: mappingData,
    status: mappingStatus
  } = (0, _kea.useValues)(mappingLogic);
  const docs = (_data$results = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results !== void 0 ? _data$results : [];
  const [pagination, setPagination] = (0, _react.useState)(DEFAULT_PAGINATION);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const searchQueryCallback = searchQ => {
    setSearchQuery(searchQ);
  };
  const shouldShowAccessControlSwitcher = hasDocumentLevelSecurityFeature;
  const isAccessControlIndexNotFound = shouldShowAccessControlSwitcher && (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404;
  (0, _react.useEffect)(() => {
    var _pagination$pageSize;
    getDocuments({
      indexName: indexToShow,
      pagination: {
        ...pagination,
        pageIndex: pagination.pageIndex,
        pageSize: (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : 10
      },
      query: searchQuery,
      http
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [indexToShow, pagination, searchQuery]);
  (0, _react.useEffect)(() => {
    setSearchQuery('');
    setPagination(DEFAULT_PAGINATION);
    getMappings({
      indexName: indexToShow,
      http
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [indexToShow]);
  return /*#__PURE__*/_react.default.createElement(_searchIndexDocuments.DocumentsOverview, {
    dataTelemetryIdPrefix: `entSearchContent-${ingestionMethod}`,
    searchQueryCallback: searchQueryCallback,
    documentComponent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isAccessControlIndexNotFound && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      size: "m",
      title: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.noIndex.title', {
        defaultMessage: 'Access Control Index not found'
      }),
      iconType: "info",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.noIndex', {
      defaultMessage: "An Access Control Index won't be created until you enable document-level security and run your first access control sync."
    }))), !isAccessControlIndexNotFound && docs.length === 0 && _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.noMappings', {
      defaultMessage: 'No documents found for index'
    }), !isAccessControlIndexNotFound && docs.length > 0 && /*#__PURE__*/_react.default.createElement(_searchIndexDocuments.DocumentList, {
      dataTelemetryIdPrefix: `entSearchContent-${ingestionMethod}`,
      docs: docs,
      docsPerPage: (_pagination$pageSize2 = pagination.pageSize) !== null && _pagination$pageSize2 !== void 0 ? _pagination$pageSize2 : 10,
      isLoading: status !== _api.Status.SUCCESS && mappingStatus !== _api.Status.SUCCESS,
      mappings: mappingData ? {
        [indexName]: mappingData
      } : undefined,
      meta: (_data$meta = data === null || data === void 0 ? void 0 : data.meta) !== null && _data$meta !== void 0 ? _data$meta : DEFAULT_PAGINATION,
      onPaginate: pageIndex => setPagination({
        ...pagination,
        pageIndex
      }),
      setDocsPerPage: pageSize => setPagination({
        ...DEFAULT_PAGINATION,
        pageSize
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    })),
    accessControlSwitch: shouldShowAccessControlSwitcher ? /*#__PURE__*/_react.default.createElement(_access_control_index_selector.AccessControlIndexSelector, {
      fullWidth: true,
      onChange: setSelectedIndexType,
      valueOfSelected: selectedIndexType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  });
};
exports.SearchIndexDocuments = SearchIndexDocuments;