"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putConnectorNameAndDescription = exports.ConnectorNameAndDescriptionApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const putConnectorNameAndDescription = async ({
  connectorId,
  http,
  description = null,
  name = ''
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}/name_and_description`;
  await (http === null || http === void 0 ? void 0 : http.put(route, {
    body: JSON.stringify({
      description,
      name
    })
  }));
  return {
    description,
    name
  };
};
exports.putConnectorNameAndDescription = putConnectorNameAndDescription;
const ConnectorNameAndDescriptionApiLogic = exports.ConnectorNameAndDescriptionApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'connector_name_and_description_api_logic'], putConnectorNameAndDescription, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.contentConnectors.content.indices.configurationConnector.nameAndDescription.successToast.title', {
    defaultMessage: 'Connector name and description updated'
  })
});