"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TheHiveUpdateIncidentResponseSchema = exports.TheHiveSecretsSchema = exports.TheHiveIncidentResponseSchema = exports.TheHiveFailureResponseSchema = exports.TheHiveCreateAlertResponseSchema = exports.TheHiveConfigSchema = exports.TheHiveAddCommentResponseSchema = exports.PushToServiceIncidentSchema = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionCreateAlertParamsSchema = exports.ExecutorParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TheHiveConfigSchema = exports.TheHiveConfigSchema = _zod.z.object({
  url: _zod.z.string(),
  organisation: _zod.z.string().nullable().default(null)
}).strict();
const TheHiveSecretsSchema = exports.TheHiveSecretsSchema = _zod.z.object({
  apiKey: _zod.z.string()
}).strict();
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _zod.z.object({
  incident: _zod.z.object({
    title: _zod.z.string(),
    description: _zod.z.string(),
    externalId: _zod.z.string().nullable().default(null),
    severity: _zod.z.coerce.number().default(_constants.TheHiveSeverity.MEDIUM).nullable().default(null),
    tlp: _zod.z.coerce.number().default(_constants.TheHiveTLP.AMBER).nullable().default(null),
    tags: _zod.z.array(_zod.z.string()).nullable().default(null)
  }).strict(),
  comments: _zod.z.array(_zod.z.object({
    comment: _zod.z.string(),
    commentId: _zod.z.string()
  }).strict()).nullable().default(null)
}).strict();
const PushToServiceIncidentSchema = exports.PushToServiceIncidentSchema = {
  title: _zod.z.string(),
  description: _zod.z.string(),
  severity: _zod.z.coerce.number().nullable().default(null),
  tlp: _zod.z.coerce.number().nullable().default(null),
  tags: _zod.z.array(_zod.z.string()).nullable().default(null)
};
const ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = _zod.z.object({
  externalId: _zod.z.string()
}).strict();
const ExecutorSubActionCreateAlertParamsSchema = exports.ExecutorSubActionCreateAlertParamsSchema = _zod.z.object({
  title: _zod.z.string(),
  description: _zod.z.string(),
  type: _zod.z.string(),
  source: _zod.z.string(),
  sourceRef: _zod.z.string(),
  severity: _zod.z.coerce.number().default(_constants.TheHiveSeverity.MEDIUM).nullable().default(null),
  isRuleSeverity: _zod.z.boolean().default(false).nullable(),
  tlp: _zod.z.coerce.number().default(_constants.TheHiveTLP.AMBER).nullable().default(null),
  tags: _zod.z.array(_zod.z.string()).nullable().default(null),
  body: _zod.z.string().nullable().default(null)
}).strict();
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _zod.z.union([_zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.PUSH_TO_SERVICE),
  subActionParams: ExecutorSubActionPushParamsSchema
}).strict(), _zod.z.object({
  subAction: _zod.z.literal(_constants.SUB_ACTION.CREATE_ALERT),
  subActionParams: ExecutorSubActionCreateAlertParamsSchema
}).strict()]);
const TheHiveIncidentResponseSchema = exports.TheHiveIncidentResponseSchema = _zod.z.object({
  _id: _zod.z.string(),
  _type: _zod.z.string(),
  _createdBy: _zod.z.string(),
  _updatedBy: _zod.z.string().nullable().default(null),
  _createdAt: _zod.z.coerce.number(),
  _updatedAt: _zod.z.coerce.number().nullable().default(null),
  number: _zod.z.coerce.number(),
  title: _zod.z.string(),
  description: _zod.z.string(),
  severity: _zod.z.coerce.number(),
  severityLabel: _zod.z.string(),
  startDate: _zod.z.coerce.number(),
  endDate: _zod.z.coerce.number().nullable().default(null),
  tags: _zod.z.array(_zod.z.string()).nullable().default(null),
  flag: _zod.z.boolean(),
  tlp: _zod.z.coerce.number(),
  tlpLabel: _zod.z.string(),
  pap: _zod.z.coerce.number(),
  papLabel: _zod.z.string(),
  status: _zod.z.string(),
  stage: _zod.z.string(),
  summary: _zod.z.string().nullable().default(null),
  impactStatus: _zod.z.string().nullable().default(null),
  assignee: _zod.z.string().nullable().default(null),
  customFields: _zod.z.array(_zod.z.record(_zod.z.string(), _zod.z.any())).nullable().default(null),
  userPermissions: _zod.z.array(_zod.z.string()).nullable().default(null),
  extraData: _zod.z.object({}).passthrough(),
  newDate: _zod.z.coerce.number(),
  inProgressDate: _zod.z.coerce.number().nullable().default(null),
  closedDate: _zod.z.coerce.number().nullable().default(null),
  alertDate: _zod.z.coerce.number().nullable().default(null),
  alertNewDate: _zod.z.coerce.number().nullable().default(null),
  alertInProgressDate: _zod.z.coerce.number().nullable().default(null),
  alertImportedDate: _zod.z.coerce.number().nullable().default(null),
  timeToDetect: _zod.z.coerce.number(),
  timeToTriage: _zod.z.coerce.number().nullable().default(null),
  timeToQualify: _zod.z.coerce.number().nullable().default(null),
  timeToAcknowledge: _zod.z.coerce.number().nullable().default(null),
  timeToResolve: _zod.z.coerce.number().nullable().default(null),
  handlingDuration: _zod.z.coerce.number().nullable().default(null)
});
const TheHiveUpdateIncidentResponseSchema = exports.TheHiveUpdateIncidentResponseSchema = _zod.z.any();
const TheHiveAddCommentResponseSchema = exports.TheHiveAddCommentResponseSchema = _zod.z.object({
  _id: _zod.z.string(),
  _type: _zod.z.string(),
  createdBy: _zod.z.string(),
  createdAt: _zod.z.coerce.number(),
  updatedAt: _zod.z.coerce.number().nullable().default(null),
  updatedBy: _zod.z.string().nullable().default(null),
  message: _zod.z.string(),
  isEdited: _zod.z.boolean(),
  extraData: _zod.z.object({}).passthrough()
});
const TheHiveCreateAlertResponseSchema = exports.TheHiveCreateAlertResponseSchema = _zod.z.object({
  _id: _zod.z.string(),
  _type: _zod.z.string(),
  _createdBy: _zod.z.string(),
  _updatedBy: _zod.z.string().nullable().default(null),
  _createdAt: _zod.z.coerce.number(),
  _updatedAt: _zod.z.coerce.number().nullable().default(null),
  type: _zod.z.string(),
  source: _zod.z.string(),
  sourceRef: _zod.z.string(),
  externalLink: _zod.z.string().nullable().default(null),
  title: _zod.z.string(),
  description: _zod.z.string(),
  severity: _zod.z.coerce.number(),
  severityLabel: _zod.z.string(),
  date: _zod.z.coerce.number(),
  tags: _zod.z.array(_zod.z.string()).nullable().default(null),
  tlp: _zod.z.coerce.number(),
  tlpLabel: _zod.z.string(),
  pap: _zod.z.coerce.number(),
  papLabel: _zod.z.string(),
  follow: _zod.z.boolean().nullable().default(null),
  customFields: _zod.z.array(_zod.z.object({}).passthrough()).nullable().default(null),
  caseTemplate: _zod.z.string().nullable().default(null),
  observableCount: _zod.z.coerce.number(),
  caseId: _zod.z.string().nullable().default(null),
  status: _zod.z.string(),
  stage: _zod.z.string(),
  assignee: _zod.z.string().nullable().default(null),
  summary: _zod.z.string().nullable().default(null),
  extraData: _zod.z.object({}).passthrough(),
  newDate: _zod.z.coerce.number(),
  inProgressDate: _zod.z.coerce.number().nullable().default(null),
  closedDate: _zod.z.coerce.number().nullable().default(null),
  importedDate: _zod.z.coerce.number().nullable().default(null),
  timeToDetect: _zod.z.coerce.number(),
  timeToTriage: _zod.z.coerce.number().nullable().default(null),
  timeToQualify: _zod.z.coerce.number().nullable().default(null),
  timeToAcknowledge: _zod.z.coerce.number().nullable().default(null)
});
const TheHiveFailureResponseSchema = exports.TheHiveFailureResponseSchema = _zod.z.object({
  type: _zod.z.coerce.number(),
  message: _zod.z.string()
});