"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commonIncidentSchemaObjectProperties = exports.PushToServiceIncidentSchema = exports.GetSeverityResponseSchema = exports.GetIncidentTypesResponseSchema = exports.GetIncidentResponseSchema = exports.GetCommonFieldsResponseSchema = exports.ExternalServiceIncidentResponseSchema = exports.ExternalServiceFieldsSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfiguration = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionGetSeverityParamsSchema = exports.ExecutorSubActionGetIncidentTypesParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _utils = require("../../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExternalIncidentServiceConfiguration = exports.ExternalIncidentServiceConfiguration = {
  apiUrl: _zod.z.string(),
  orgId: _zod.z.string()
};
const ExternalIncidentServiceConfigurationSchema = exports.ExternalIncidentServiceConfigurationSchema = _zod.z.object(ExternalIncidentServiceConfiguration).strict();
const ExternalIncidentServiceSecretConfiguration = exports.ExternalIncidentServiceSecretConfiguration = {
  apiKeyId: _zod.z.string(),
  apiKeySecret: _zod.z.string()
};
const ExternalIncidentServiceSecretConfigurationSchema = exports.ExternalIncidentServiceSecretConfigurationSchema = _zod.z.object(ExternalIncidentServiceSecretConfiguration).strict();
const MAX_ADDITIONAL_FIELDS_LENGTH = 50;
const AdditionalFields = {
  additionalFields: (0, _utils.Coerced)(_zod.z.record(_zod.z.string().superRefine((value, ctx) => {
    validateOtherFieldsKeys(value, ctx);
  }), _zod.z.any()).superRefine((val, ctx) => (0, _utils.validateRecordMaxKeys)({
    record: val,
    ctx,
    maxNumberOfFields: MAX_ADDITIONAL_FIELDS_LENGTH,
    fieldName: 'additionalFields'
  })).nullable().default(null))
};
const CommonIncidentAttributes = {
  name: _zod.z.string(),
  description: _zod.z.string().nullable().default(null),
  externalId: _zod.z.string().nullable().default(null),
  incidentTypes: _zod.z.array(_zod.z.coerce.number()).nullable().default(null),
  severityCode: _zod.z.coerce.number().nullable().default(null),
  ...AdditionalFields
};
const commonIncidentSchemaObjectProperties = exports.commonIncidentSchemaObjectProperties = Object.keys(CommonIncidentAttributes);
const validateOtherFieldsKeys = (key, ctx) => {
  (0, _utils.validateKeysAllowed)({
    key,
    ctx,
    disallowList: commonIncidentSchemaObjectProperties,
    fieldName: 'additionalFields'
  });
};
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _zod.z.object({
  incident: _zod.z.object({
    ...CommonIncidentAttributes
  }).strict(),
  comments: _zod.z.array(_zod.z.object({
    comment: _zod.z.string(),
    commentId: _zod.z.string()
  }).strict()).nullable().default(null)
});
const PushToServiceIncidentSchema = exports.PushToServiceIncidentSchema = {
  name: _zod.z.string(),
  description: _zod.z.string().nullable().default(null),
  incidentTypes: _zod.z.array(_zod.z.coerce.number()).nullable().default(null),
  severityCode: _zod.z.coerce.number().nullable().default(null),
  ...AdditionalFields
};

// Reserved for future implementation
const ExecutorSubActionCommonFieldsParamsSchema = exports.ExecutorSubActionCommonFieldsParamsSchema = _zod.z.object({}).strict();
const ExecutorSubActionGetIncidentTypesParamsSchema = exports.ExecutorSubActionGetIncidentTypesParamsSchema = _zod.z.object({}).strict();
const ExecutorSubActionGetSeverityParamsSchema = exports.ExecutorSubActionGetSeverityParamsSchema = _zod.z.object({}).strict();
const ArrayOfValuesSchema = _zod.z.array(_zod.z.object({
  value: _zod.z.coerce.number(),
  label: _zod.z.string()
}).passthrough());
const GetIncidentTypesResponseSchema = exports.GetIncidentTypesResponseSchema = _zod.z.object({
  values: ArrayOfValuesSchema
}).passthrough();
const GetSeverityResponseSchema = exports.GetSeverityResponseSchema = _zod.z.object({
  values: ArrayOfValuesSchema
}).passthrough();
const ValuesItemSchema = _zod.z.object({
  value: _zod.z.union([_zod.z.coerce.number(), _zod.z.string()]),
  label: _zod.z.string(),
  enabled: _zod.z.boolean(),
  hidden: _zod.z.boolean(),
  default: _zod.z.boolean()
}).passthrough();
const ExternalServiceFieldsSchema = exports.ExternalServiceFieldsSchema = _zod.z.object({
  input_type: _zod.z.string(),
  name: _zod.z.string(),
  read_only: _zod.z.boolean(),
  required: _zod.z.string().nullable().default(null),
  text: _zod.z.string(),
  prefix: _zod.z.string().nullable().default(null),
  values: _zod.z.array(ValuesItemSchema).nullable().default(null)
}).passthrough();
const GetCommonFieldsResponseSchema = exports.GetCommonFieldsResponseSchema = _zod.z.array(ExternalServiceFieldsSchema);
const ExternalServiceIncidentResponseSchema = exports.ExternalServiceIncidentResponseSchema = _zod.z.object({
  id: _zod.z.string(),
  title: _zod.z.string(),
  url: _zod.z.string(),
  pushedDate: _zod.z.string()
}).strict();
const GetIncidentResponseSchema = exports.GetIncidentResponseSchema = _zod.z.object({
  id: _zod.z.coerce.number(),
  inc_last_modified_date: _zod.z.coerce.number()
}).passthrough();