"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecretsSchema = exports.ParamsSchema = exports.ConfigSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ConfigSchema = exports.ConfigSchema = _zod.z.object({
  index: _zod.z.string(),
  refresh: _zod.z.boolean().default(false),
  executionTimeField: _zod.z.string().nullable().default(null)
}).strict();
const SecretsSchema = exports.SecretsSchema = _zod.z.object({}).strict().default({});

// see: https://www.elastic.co/guide/en/elasticsearch/reference/current/actions-index.html
// - timeout not added here, as this seems to be a generic thing we want to do
//   eventually: https://github.com/elastic/kibana/projects/26#card-24087404
const ParamsSchema = exports.ParamsSchema = _zod.z.object({
  documents: _zod.z.array(_zod.z.record(_zod.z.string(), _zod.z.any())),
  indexOverride: _zod.z.string().nullable().default(null).refine(pattern => pattern === null || pattern && pattern.startsWith(_constants.ALERT_HISTORY_PREFIX), {
    message: `index must start with "${_constants.ALERT_HISTORY_PREFIX}"`
  })
}).strict();