"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformEntityTypeToIconAndShape = void 0;
var _entity_type_constants = require("../entity_type_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Interface for visual properties returned by the transform function
 */

/**
 * Transforms entity type to standardized icon and shape values
 * This helps normalize different entity type representations to consistent visual properties
 *
 * @param entityGroupType The type of the entity group
 * @returns Object containing the icon and shape for the entity
 */
const transformEntityTypeToIconAndShape = entityGroupType => {
  if (!entityGroupType) {
    return {};
  }
  const entityGroupTypeLower = entityGroupType.toLowerCase();
  return {
    icon: _entity_type_constants.entityTypeMappings.icons[entityGroupTypeLower],
    shape: _entity_type_constants.entityTypeMappings.shapes[entityGroupTypeLower]
  };
};
exports.transformEntityTypeToIconAndShape = transformEntityTypeToIconAndShape;