"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findBenchmarkRuleHandler = void 0;
var _helpers = require("../../../../common/utils/helpers");
var _constants = require("../../../../common/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findBenchmarkRuleHandler = async (soClient, options) => {
  if (!options.packagePolicyId && !options.benchmarkId || options.packagePolicyId && options.benchmarkId) {
    throw new Error('Please provide either benchmarkId or packagePolicyId, but not both');
  }
  const benchmarkId = options.benchmarkId ? options.benchmarkId : await (0, _utils.getBenchmarkIdFromPackagePolicyId)(soClient, options.packagePolicyId);
  const cspCspBenchmarkRulesSo = await soClient.find({
    type: _constants.CSP_BENCHMARK_RULE_SAVED_OBJECT_TYPE,
    searchFields: options.searchFields,
    search: options.search ? `"${options.search}"*` : '',
    page: options.page,
    perPage: options.perPage,
    sortField: options.sortField,
    fields: options === null || options === void 0 ? void 0 : options.fields,
    filter: (0, _helpers.getBenchmarkFilter)(benchmarkId, options.section)
  });
  const cspBenchmarkRules = cspCspBenchmarkRulesSo.saved_objects.map(cspBenchmarkRule => cspBenchmarkRule.attributes);

  // Semantic version sorting using semver for valid versions and custom comparison for invalid versions
  const sortedCspBenchmarkRules = (0, _utils.getSortedCspBenchmarkRulesTemplates)(cspBenchmarkRules, 'asc');
  return {
    items: sortedCspBenchmarkRules,
    total: cspCspBenchmarkRulesSo.total,
    page: options.page,
    perPage: options.perPage
  };
};
exports.findBenchmarkRuleHandler = findBenchmarkRuleHandler;