"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCommonError = exports.SUBSCRIPTION_NOT_ALLOWED_TEST_SUBJECT = exports.PACKAGE_NOT_INSTALLED_TEST_SUBJECT = exports.LOADING_STATE_TEST_SUBJECT = exports.ERROR_STATE_TEST_SUBJECT = exports.DEFAULT_NO_DATA_TEST_SUBJECT = exports.CloudDefendPage = exports.CloudDefendNoDataPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _subscription_not_allowed = require("../subscription_not_allowed");
var _use_subscription_status = require("../../common/hooks/use_subscription_status");
var _full_size_page = require("../full_size_page");
var _use_setup_status_api = require("../../common/api/use_setup_status_api");
var _loading_state = require("../loading_state");
var _use_cloud_defend_integration_links = require("../../common/navigation/use_cloud_defend_integration_links");
var _logo = _interopRequireDefault(require("../../assets/icons/logo.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_defend/public/components/cloud_defend_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LOADING_STATE_TEST_SUBJECT = exports.LOADING_STATE_TEST_SUBJECT = 'cloud_defend_page_loading';
const ERROR_STATE_TEST_SUBJECT = exports.ERROR_STATE_TEST_SUBJECT = 'cloud_defend_page_error';
const PACKAGE_NOT_INSTALLED_TEST_SUBJECT = exports.PACKAGE_NOT_INSTALLED_TEST_SUBJECT = 'cloud_defend_page_package_not_installed';
const DEFAULT_NO_DATA_TEST_SUBJECT = exports.DEFAULT_NO_DATA_TEST_SUBJECT = 'cloud_defend_page_no_data';
const SUBSCRIPTION_NOT_ALLOWED_TEST_SUBJECT = exports.SUBSCRIPTION_NOT_ALLOWED_TEST_SUBJECT = 'cloud_defend_page_subscription_not_allowed';
const isCommonError = error => {
  var _body, _body2, _body3;
  if (!(error !== null && error !== void 0 && error.body) || !(error !== null && error !== void 0 && (_body = error.body) !== null && _body !== void 0 && _body.error) || !(error !== null && error !== void 0 && (_body2 = error.body) !== null && _body2 !== void 0 && _body2.message) || !(error !== null && error !== void 0 && (_body3 = error.body) !== null && _body3 !== void 0 && _body3.statusCode)) {
    return false;
  }
  return true;
};
exports.isCommonError = isCommonError;
const CloudDefendNoDataPage = ({
  pageTitle,
  docsLink,
  actionHref,
  actionTitle,
  actionDescription,
  testId
}) => {
  return /*#__PURE__*/_react.default.createElement(_public.NoDataPage, {
    "data-test-subj": testId,
    css: (0, _react2.css)`
        > :nth-child(3) {
          display: block;
          margin: auto;
          width: 450px;
        }
      `,
    pageTitle: pageTitle,
    solution: _i18n.i18n.translate('xpack.cloudDefend.cloudDefendPage.packageNotInstalled.solutionNameLabel', {
      defaultMessage: 'Defend for containers (D4C)'
    }),
    docsLink: docsLink,
    logo: "logoSecurity",
    actions: {
      elasticAgent: {
        href: actionHref,
        isDisabled: !actionHref,
        title: actionTitle,
        description: actionDescription
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  });
};
exports.CloudDefendNoDataPage = CloudDefendNoDataPage;
const packageNotInstalledRenderer = ({
  addIntegrationLink,
  docsLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_full_size_page.FullSizeCenteredPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": PACKAGE_NOT_INSTALLED_TEST_SUBJECT,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "m",
      margin: "m",
      src: _logo.default,
      alt: "",
      role: "presentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 15
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDefend.cloudDefendPage.packageNotInstalledRenderer.promptTitle",
      defaultMessage: "Detect container drift and block malicious behavior at the source!",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDefend.cloudDefendPage.packageNotInstalledRenderer.promptDescription",
      defaultMessage: "Add the Defend for containers (D4C) integration to begin. {learnMore}.",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docsLink,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.cloudDefend.cloudDefendPage.packageNotInstalledRenderer.learnMoreTitle",
          defaultMessage: "Learn more about Defend for containers (D4C)",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 13
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: addIntegrationLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudDefend.cloudDefendPage.packageNotInstalledRenderer.addCloudDefendmIntegrationButtonTitle",
      defaultMessage: "Add D4C Integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 17
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }));
};
const defaultLoadingRenderer = () => /*#__PURE__*/_react.default.createElement(_loading_state.LoadingState, {
  "data-test-subj": LOADING_STATE_TEST_SUBJECT,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 164,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.cloudDefend.cloudDefendPage.loadingDescription",
  defaultMessage: "Loading...",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 165,
    columnNumber: 5
  }
}));
const defaultErrorRenderer = error => /*#__PURE__*/_react.default.createElement(_full_size_page.FullSizeCenteredPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 173,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  color: "danger",
  iconType: "warning",
  "data-test-subj": ERROR_STATE_TEST_SUBJECT,
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudDefend.cloudDefendPage.errorRenderer.errorTitle",
    defaultMessage: "We couldn't fetch your cloud defend data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  })),
  body: isCommonError(error) ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudDefend.cloudDefendPage.errorRenderer.errorDescription",
    defaultMessage: "{error} {statusCode}: {body}",
    values: {
      error: error.body.error,
      statusCode: error.body.statusCode,
      body: error.body.message
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  })) : undefined,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 174,
    columnNumber: 5
  }
}));
const defaultNoDataRenderer = docsLink => /*#__PURE__*/_react.default.createElement(_full_size_page.FullSizeCenteredPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 206,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_public.NoDataPage, {
  "data-test-subj": DEFAULT_NO_DATA_TEST_SUBJECT,
  pageTitle: _i18n.i18n.translate('xpack.cloudDefend.cloudDefendPage.defaultNoDataConfig.pageTitle', {
    defaultMessage: 'No data found'
  }),
  solution: _i18n.i18n.translate('xpack.cloudDefend.cloudDefendPage.defaultNoDataConfig.solutionNameLabel', {
    defaultMessage: 'Defend for containers'
  }),
  docsLink: docsLink,
  logo: 'logoSecurity',
  actions: {},
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 207,
    columnNumber: 5
  }
}));
const subscriptionNotAllowedRenderer = () => /*#__PURE__*/_react.default.createElement(_full_size_page.FullSizeCenteredPage, {
  "data-test-subj": SUBSCRIPTION_NOT_ALLOWED_TEST_SUBJECT,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 226,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_subscription_not_allowed.SubscriptionNotAllowed, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 227,
    columnNumber: 5
  }
}));
const CloudDefendPage = ({
  children,
  query,
  loadingRender = defaultLoadingRenderer,
  errorRender = defaultErrorRenderer,
  noDataRenderer = defaultNoDataRenderer
}) => {
  const subscriptionStatus = (0, _use_subscription_status.useSubscriptionStatus)();
  const getSetupStatus = (0, _use_setup_status_api.useCloudDefendSetupStatusApi)();
  const {
    addIntegrationLink,
    docsLink
  } = (0, _use_cloud_defend_integration_links.useCloudDefendIntegrationLinks)();
  const render = () => {
    if (subscriptionStatus.isError) {
      return defaultErrorRenderer(subscriptionStatus.error);
    }
    if (subscriptionStatus.isLoading) {
      return defaultLoadingRenderer();
    }
    if (!subscriptionStatus.data) {
      return subscriptionNotAllowedRenderer();
    }
    if (getSetupStatus.isError) {
      return defaultErrorRenderer(getSetupStatus.error);
    }
    if (getSetupStatus.isLoading) {
      return defaultLoadingRenderer();
    }
    if (getSetupStatus.data.status === 'not-installed') {
      return packageNotInstalledRenderer({
        addIntegrationLink,
        docsLink
      });
    }
    if (!query) {
      return children;
    }
    if (query.isError) {
      return errorRender(query.error);
    }
    if (query.isLoading) {
      return loadingRender();
    }
    if (!query.data) {
      return noDataRenderer(docsLink);
    }
    return children;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, render());
};
exports.CloudDefendPage = CloudDefendPage;