"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloudConnectedFeature = exports.CLOUD_CONNECTED_FEATURE_ID = exports.CLOUD_CONNECTED_APP_ID = void 0;
var _server = require("@kbn/core/server");
var _common = require("../common");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_CONNECTED_FEATURE_ID = exports.CLOUD_CONNECTED_FEATURE_ID = 'cloudConnect';
const CLOUD_CONNECTED_APP_ID = exports.CLOUD_CONNECTED_APP_ID = 'cloud_connect';
const cloudConnectedFeature = exports.cloudConnectedFeature = {
  id: CLOUD_CONNECTED_FEATURE_ID,
  name: _common.PLUGIN_NAME,
  category: _server.DEFAULT_APP_CATEGORIES.management,
  order: 9035,
  app: [CLOUD_CONNECTED_APP_ID, 'kibana'],
  catalogue: [CLOUD_CONNECTED_FEATURE_ID],
  management: {
    kibana: [CLOUD_CONNECTED_APP_ID]
  },
  privileges: {
    all: {
      app: [CLOUD_CONNECTED_APP_ID, 'kibana'],
      catalogue: [CLOUD_CONNECTED_FEATURE_ID],
      management: {
        kibana: [CLOUD_CONNECTED_APP_ID]
      },
      savedObject: {
        all: [_constants.CLOUD_CONNECT_API_KEY_TYPE],
        read: [_constants.CLOUD_CONNECT_API_KEY_TYPE]
      },
      ui: ['show', 'configure'],
      api: []
    },
    read: {
      app: [CLOUD_CONNECTED_APP_ID, 'kibana'],
      catalogue: [CLOUD_CONNECTED_FEATURE_ID],
      management: {
        kibana: [CLOUD_CONNECTED_APP_ID]
      },
      savedObject: {
        all: [],
        read: [_constants.CLOUD_CONNECT_API_KEY_TYPE]
      },
      ui: ['show'],
      api: []
    }
  }
};