"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ZCasesGroupedAlertsSchema = exports.ZCasesConnectorRunParamsSchema = exports.CasesGroupedAlertsSchema = exports.CasesConnectorSecretsSchema = exports.CasesConnectorRunParamsSchema = exports.CasesConnectorRuleActionParamsSchema = exports.CasesConnectorParamsSchema = exports.CasesConnectorConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _zod = require("@kbn/zod");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _constants = require("./constants");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
  validate: value => {
    if (!Object.hasOwn(value, '_id') || !Object.hasOwn(value, '_index')) {
      return 'Alert ID and index must be defined';
    }
  }
});

/**
 * At the moment only one field is supported for grouping
 */
const GroupingSchema = _configSchema.schema.arrayOf(_configSchema.schema.string(), {
  minSize: 0,
  maxSize: 1
});
const RuleSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  ruleUrl: _configSchema.schema.nullable(_configSchema.schema.string())
});
const ReopenClosedCasesSchema = _configSchema.schema.boolean({
  defaultValue: false
});
const TimeWindowSchema = _configSchema.schema.string({
  defaultValue: '7d',
  validate: value => {
    /**
     * Validates the time window.
     * Acceptable format:
     * - First character should be a digit from 1 to 9
     * - All next characters should be a digit from 0 to 9
     * - The last character should be d (day), w (week), h (hour), m (minute)
     *
     * Example: 20d, 2w, etc
     */
    const timeWindowRegex = new RegExp(_constants2.CASES_CONNECTOR_TIME_WINDOW_REGEX, 'g');
    if (!timeWindowRegex.test(value)) {
      return 'Not a valid time window';
    }
    const date = _datemath.default.parse(`now-${value}`);
    if (!date || !date.isValid()) {
      return 'Not a valid time window';
    }
    const timeSize = value.slice(0, -1);
    const timeUnit = value.slice(-1);
    const timeSizeAsNumber = Number(timeSize);
    if (timeUnit === 'm' && timeSizeAsNumber < 5) {
      return 'Time window should be at least 5 minutes';
    }
  }
});
const CasesGroupedAlertsSchema = exports.CasesGroupedAlertsSchema = _configSchema.schema.object({
  alerts: _configSchema.schema.arrayOf(AlertSchema, {
    maxSize: _constants2.MAX_ALERTS_PER_CASE
  }),
  comments: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: _constants2.MAX_DOCS_PER_PAGE / 2
  })),
  grouping: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
  title: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: _constants2.MAX_TITLE_LENGTH
  }))
});

/**
 * The case connector does not have any configuration
 * or secrets.
 */
const CasesConnectorConfigSchema = exports.CasesConnectorConfigSchema = _zod.z.object({}).strict();
const CasesConnectorSecretsSchema = exports.CasesConnectorSecretsSchema = _zod.z.object({}).strict();
const CasesConnectorRunParamsSchema = exports.CasesConnectorRunParamsSchema = _configSchema.schema.object({
  alerts: _configSchema.schema.arrayOf(AlertSchema),
  groupedAlerts: _configSchema.schema.nullable(_configSchema.schema.arrayOf(CasesGroupedAlertsSchema, {
    defaultValue: [],
    minSize: 0,
    maxSize: _constants.MAX_OPEN_CASES
  })),
  groupingBy: GroupingSchema,
  owner: _configSchema.schema.string(),
  rule: RuleSchema,
  timeWindow: TimeWindowSchema,
  reopenClosedCases: ReopenClosedCasesSchema,
  maximumCasesToOpen: _configSchema.schema.number({
    defaultValue: _constants.DEFAULT_MAX_OPEN_CASES,
    min: 1,
    max: _constants.MAX_OPEN_CASES
  }),
  templateId: _configSchema.schema.nullable(_configSchema.schema.string()),
  internallyManagedAlerts: _configSchema.schema.nullable(_configSchema.schema.boolean({
    defaultValue: false
  }))
});
const ZAlertSchema = _zod.z.record(_zod.z.string(), _zod.z.any()).superRefine((value, ctx) => {
  if (!Object.hasOwn(value, '_id') || !Object.hasOwn(value, '_index')) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'Alert ID and index must be defined'
    });
  }
});
const ZCasesGroupedAlertsSchema = exports.ZCasesGroupedAlertsSchema = _zod.z.object({
  alerts: _zod.z.array(ZAlertSchema).max(_constants2.MAX_ALERTS_PER_CASE),
  comments: _zod.z.array(_zod.z.string()).max(_constants2.MAX_DOCS_PER_PAGE / 2).optional(),
  grouping: _zod.z.record(_zod.z.string(), _zod.z.any()),
  title: _zod.z.string().max(_constants2.MAX_TITLE_LENGTH).optional()
}).strict();
const ZGroupingSchema = _zod.z.array(_zod.z.string()).min(0).max(1);
const ZRuleSchema = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string(),
  tags: _zod.z.array(_zod.z.string()).default([]),
  ruleUrl: _zod.z.string().nullable().default(null)
}).strict();
const ZTimeWindowSchema = _zod.z.string().default('7d').superRefine((value, ctx) => {
  /**
   * Validates the time window.
   * Acceptable format:
   * - First character should be a digit from 1 to 9
   * - All next characters should be a digit from 0 to 9
   * - The last character should be d (day), w (week), h (hour), m (minute)
   *
   * Example: 20d, 2w, etc
   */
  const timeWindowRegex = new RegExp(_constants2.CASES_CONNECTOR_TIME_WINDOW_REGEX, 'g');
  if (!timeWindowRegex.test(value)) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'Not a valid time window'
    });
  }
  const date = _datemath.default.parse(`now-${value}`);
  if (!date || !date.isValid()) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'Not a valid time window'
    });
  }
  const timeSize = value.slice(0, -1);
  const timeUnit = value.slice(-1);
  const timeSizeAsNumber = Number(timeSize);
  if (timeUnit === 'm' && timeSizeAsNumber < 5) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'Time window should be at least 5 minutes'
    });
  }
});
const ZReopenClosedCasesSchema = _zod.z.boolean().default(false);
const ZCasesConnectorRunParamsSchema = exports.ZCasesConnectorRunParamsSchema = _zod.z.object({
  alerts: _zod.z.array(ZAlertSchema),
  groupedAlerts: _zod.z.array(ZCasesGroupedAlertsSchema).min(0).max(_constants.MAX_OPEN_CASES).default([]).nullable(),
  groupingBy: ZGroupingSchema,
  owner: _zod.z.string(),
  rule: ZRuleSchema,
  timeWindow: ZTimeWindowSchema,
  reopenClosedCases: ZReopenClosedCasesSchema,
  maximumCasesToOpen: _zod.z.coerce.number().min(1).max(_constants.MAX_OPEN_CASES).default(_constants.DEFAULT_MAX_OPEN_CASES),
  templateId: _zod.z.string().nullable().default(null),
  internallyManagedAlerts: _zod.z.boolean().default(false).nullable()
}).strict();
const CasesConnectorRuleActionParamsSchema = exports.CasesConnectorRuleActionParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('run'),
  subActionParams: _configSchema.schema.object({
    groupingBy: GroupingSchema,
    reopenClosedCases: ReopenClosedCasesSchema,
    timeWindow: TimeWindowSchema,
    templateId: _configSchema.schema.nullable(_configSchema.schema.string())
  })
});
const CasesConnectorParamsSchema = exports.CasesConnectorParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('run'),
  subActionParams: CasesConnectorRunParamsSchema
});