"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckDocumentAttachments = void 0;
var _react = require("react");
var _use_find_cases_containing_all_selected_alerts = require("./use_find_cases_containing_all_selected_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hasDocumentId(arg) {
  const candidate = arg;
  if (candidate === null || typeof candidate !== 'object') {
    return false;
  }
  const hasAlertId = 'alertId' in candidate && (Array.isArray(candidate.alertId) || typeof candidate.alertId === 'string');
  const hasEventId = 'eventId' in candidate && (Array.isArray(candidate.eventId) || typeof candidate.eventId === 'string');
  return hasAlertId || hasEventId;
}
const useCheckDocumentAttachments = ({
  cases,
  getAttachments
}) => {
  var _getAttachments;
  const selectedDocuments = ((_getAttachments = getAttachments === null || getAttachments === void 0 ? void 0 : getAttachments({
    theCase: undefined
  })) !== null && _getAttachments !== void 0 ? _getAttachments : []).filter(hasDocumentId).map(({
    alertId,
    eventId
  }) => [alertId, eventId]).flatMap(arrayOrString => arrayOrString).filter(Boolean);
  const {
    data,
    isFetching
  } = (0, _use_find_cases_containing_all_selected_alerts.useFindCasesContainingAllSelectedDocuments)(selectedDocuments, cases.map(({
    id
  }) => id));
  const disabledCases = (0, _react.useMemo)(() => {
    var _data$casesWithAllAtt;
    return new Set((_data$casesWithAllAtt = data === null || data === void 0 ? void 0 : data.casesWithAllAttachments) !== null && _data$casesWithAllAtt !== void 0 ? _data$casesWithAllAtt : []);
  }, [data]);
  return {
    disabledCases,
    isLoading: isFetching
  };
};
exports.useCheckDocumentAttachments = useCheckDocumentAttachments;