"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileDeleteButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_delete_file_attachment = require("../../containers/use_delete_file_attachment");
var _use_delete_property_action = require("../user_actions/property_actions/use_delete_property_action");
var _delete_attachment_confirmation_modal = require("../user_actions/delete_attachment_confirmation_modal");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/files/file_delete_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FileDeleteButtonComponent = ({
  caseId,
  fileId,
  isIcon
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isLoading,
    mutate: deleteFileAttachment
  } = (0, _use_delete_file_attachment.useDeleteFileAttachment)();
  const {
    showDeletionModal,
    onModalOpen,
    onConfirm,
    onCancel
  } = (0, _use_delete_property_action.useDeletePropertyAction)({
    onDelete: () => deleteFileAttachment({
      caseId,
      fileId
    })
  });
  const buttonRef = _react.default.useRef(null);
  const buttonProps = {
    iconType: 'trash',
    'aria-label': i18n.DELETE_FILE,
    color: 'danger',
    isDisabled: isLoading,
    onClick: onModalOpen,
    'data-test-subj': 'cases-files-delete-button',
    buttonRef
  };
  return permissions.delete ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isIcon ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({}, buttonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, buttonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }), i18n.DELETE_FILE), showDeletionModal ? /*#__PURE__*/_react.default.createElement(_delete_attachment_confirmation_modal.DeleteAttachmentConfirmationModal, {
    title: i18n.DELETE_FILE_TITLE,
    confirmButtonText: i18n.DELETE,
    onCancel: onCancel,
    onConfirm: onConfirm,
    focusButtonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }) : null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
FileDeleteButtonComponent.displayName = 'FileDeleteButton';
const FileDeleteButton = exports.FileDeleteButton = /*#__PURE__*/_react.default.memo(FileDeleteButtonComponent);