"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVERLESS_PROJECT_TYPES = exports.SECURITY_SOLUTION_OWNER = exports.SECURITY_PROJECT_TYPE_ID = exports.OWNER_INFO = exports.OWNERS = exports.OBSERVABILITY_PROJECT_TYPE_ID = exports.OBSERVABILITY_OWNER = exports.GENERAL_CASES_OWNER = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _application = require("./application");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Owner
 */
const SECURITY_SOLUTION_OWNER = exports.SECURITY_SOLUTION_OWNER = 'securitySolution';
const OBSERVABILITY_OWNER = exports.OBSERVABILITY_OWNER = 'observability';
const GENERAL_CASES_OWNER = exports.GENERAL_CASES_OWNER = _application.APP_ID;
const SECURITY_PROJECT_TYPE_ID = exports.SECURITY_PROJECT_TYPE_ID = 'security';
const OBSERVABILITY_PROJECT_TYPE_ID = exports.OBSERVABILITY_PROJECT_TYPE_ID = 'observability';
const OWNERS = exports.OWNERS = [GENERAL_CASES_OWNER, OBSERVABILITY_OWNER, SECURITY_SOLUTION_OWNER];
const SERVERLESS_PROJECT_TYPES = exports.SERVERLESS_PROJECT_TYPES = [SECURITY_PROJECT_TYPE_ID, OBSERVABILITY_PROJECT_TYPE_ID];
const OWNER_INFO = exports.OWNER_INFO = {
  [SECURITY_SOLUTION_OWNER]: {
    id: SECURITY_SOLUTION_OWNER,
    appId: 'securitySolutionUI',
    label: 'Security',
    iconType: 'logoSecurity',
    appRoute: '/app/security',
    validRuleConsumers: [_ruleDataUtils.AlertConsumers.SIEM],
    serverlessProjectType: SECURITY_PROJECT_TYPE_ID
  },
  [OBSERVABILITY_OWNER]: {
    id: OBSERVABILITY_OWNER,
    appId: 'observability-overview',
    label: 'Observability',
    iconType: 'logoObservability',
    appRoute: '/app/observability',
    validRuleConsumers: [
    // only valid in serverless
    _ruleDataUtils.AlertConsumers.OBSERVABILITY, _ruleDataUtils.AlertConsumers.APM, _ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.UPTIME, _ruleDataUtils.AlertConsumers.MONITORING, _ruleDataUtils.AlertConsumers.STREAMS],
    serverlessProjectType: OBSERVABILITY_PROJECT_TYPE_ID
  },
  [GENERAL_CASES_OWNER]: {
    id: GENERAL_CASES_OWNER,
    appId: 'management',
    label: 'Management',
    iconType: 'managementApp',
    appRoute: '/app/management/insightsAndAlerting',
    validRuleConsumers: [_ruleDataUtils.AlertConsumers.ML, _ruleDataUtils.AlertConsumers.STACK_ALERTS, _ruleDataUtils.AlertConsumers.EXAMPLE, _ruleDataUtils.AlertConsumers.DISCOVER]
  }
};