"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listConfigurations = listConfigurations;
var _server = require("@kbn/apm-sources-access-plugin/server");
var _convert_settings_to_string = require("./convert_settings_to_string");
var _get_agent_config_etag_metrics = require("./get_agent_config_etag_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function listConfigurations({
  internalESClient,
  apmEventClient,
  apmIndices
}) {
  const params = {
    index: _server.APM_AGENT_CONFIGURATION_INDEX,
    size: 200
  };
  const [agentConfigs, appliedEtags = []] = await Promise.all([internalESClient.search('list_agent_configuration', params), apmEventClient ? (0, _get_agent_config_etag_metrics.getAgentConfigEtagMetrics)(apmEventClient) : undefined]);
  return agentConfigs.hits.hits.map(_convert_settings_to_string.convertConfigSettingsToString).map(hit => {
    return {
      ...hit._source,
      applied_by_agent: hit._source.applied_by_agent || appliedEtags.includes(hit._source.etag)
    };
  });
}