"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFleetPackageInfo = getFleetPackageInfo;
var _errors = require("@kbn/fleet-plugin/server/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getFleetPackageInfo(resources) {
  var _resources$plugins$fl;
  const fleetPluginStart = await ((_resources$plugins$fl = resources.plugins.fleet) === null || _resources$plugins$fl === void 0 ? void 0 : _resources$plugins$fl.start());
  try {
    const packageInfo = await (fleetPluginStart === null || fleetPluginStart === void 0 ? void 0 : fleetPluginStart.packageService.asScoped(resources.request).getInstallation('apm'));
    return {
      isInstalled: (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.install_status) === 'installed',
      version: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.version
    };
  } catch (e) {
    if (e instanceof _errors.FleetUnauthorizedError) {
      console.error('Insufficient permissions to access fleet package info');
      return {
        isInstalled: false,
        version: 'N/A'
      };
    }
    throw e;
  }
}