"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupByTerms = void 0;
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _apm = require("../../../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGroupByTerms = (groupByFields = []) => {
  return groupByFields.map(groupByField => {
    return {
      field: groupByField,
      missing: groupByField === _apm.SERVICE_ENVIRONMENT ? _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value : undefined
    };
  });
};
exports.getGroupByTerms = getGroupByTerms;