"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionLatencyChartsFetcher = useTransactionLatencyChartsFetcher;
var _react = require("react");
var _document_type = require("../../common/document_type");
var _get_comparison_options = require("../components/shared/time_comparison/get_comparison_options");
var _use_apm_service_context = require("../context/apm_service/use_apm_service_context");
var _latency_chart_selectors = require("../selectors/latency_chart_selectors");
var _use_apm_params = require("./use_apm_params");
var _use_fetcher = require("./use_fetcher");
var _use_preferred_data_source_and_bucket_size = require("./use_preferred_data_source_and_bucket_size");
var _use_previous_period_text = require("./use_previous_period_text");
var _use_time_range = require("./use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTransactionLatencyChartsFetcher({
  kuery,
  environment,
  transactionName,
  latencyAggregationType
}) {
  var _preferred$source;
  const {
    transactionType,
    serviceName,
    transactionTypeStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      rangeFrom,
      rangeTo,
      offset,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    kuery,
    numBuckets: 100,
    start,
    end,
    type: transactionName ? _document_type.ApmDocumentType.TransactionMetric : _document_type.ApmDocumentType.ServiceTransactionMetric
  });
  const shouldUseDurationSummary = latencyAggregationType === 'avg' && (preferred === null || preferred === void 0 ? void 0 : (_preferred$source = preferred.source) === null || _preferred$source === void 0 ? void 0 : _preferred$source.hasDurationSummaryField);
  const {
    data,
    error,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!transactionType && transactionTypeStatus === _use_fetcher.FETCH_STATUS.SUCCESS) {
      return Promise.resolve(undefined);
    }
    if (serviceName && start && end && transactionType && latencyAggregationType && preferred) {
      return callApmApi('GET /internal/apm/services/{serviceName}/transactions/charts/latency', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            transactionType,
            useDurationSummary: !!shouldUseDurationSummary,
            transactionName: transactionName || undefined,
            latencyAggregationType,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            bucketSizeInSeconds: preferred.bucketSizeInSeconds
          }
        }
      });
    }
  }, [transactionType, transactionTypeStatus, serviceName, start, end, latencyAggregationType, preferred, environment, kuery, shouldUseDurationSummary, transactionName, comparisonEnabled, offset]);
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const memoizedData = (0, _react.useMemo)(() => (0, _latency_chart_selectors.getLatencyChartSelector)({
    latencyChart: data,
    latencyAggregationType,
    previousPeriodLabel
  }),
  // It should only update when the data has changed
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data]);
  return {
    bucketSizeInSeconds: preferred === null || preferred === void 0 ? void 0 : preferred.bucketSizeInSeconds,
    start,
    end,
    latencyChartsData: memoizedData,
    latencyChartsStatus: status,
    latencyChartsError: error
  };
}