"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseDiscoverButton = BaseDiscoverButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/discover_links/base_discover_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function BaseDiscoverButton({
  dataTestSubj,
  esqlQuery,
  rangeTo,
  rangeFrom,
  label,
  ariaLabel
}) {
  var _share$url$locators$g;
  const {
    share
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    indexSettingsStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const discoverHref = (_share$url$locators$g = share.url.locators.get(_deeplinksAnalytics.DISCOVER_APP_LOCATOR)) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.getRedirectUrl({
    timeRange: {
      from: rangeFrom,
      to: rangeTo
    },
    query: {
      esql: esqlQuery
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": ariaLabel,
    isLoading: indexSettingsStatus === _public.FETCH_STATUS.LOADING,
    "data-test-subj": dataTestSubj,
    iconType: "discoverApp",
    href: discoverHref,
    isDisabled: !esqlQuery || indexSettingsStatus !== _public.FETCH_STATUS.SUCCESS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, label);
}