"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentInstructionsAccordion = AgentInstructionsAccordion;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _customIcons = require("@kbn/custom-icons");
var _agent_config_instructions = require("../../../tutorial/config_agent/agent_config_instructions");
var _render_mustache = require("./render_mustache");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/fleet_integration/apm_agents/agent_instructions_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AccordionButtonContent({
  agentName,
  title
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
    size: "xl",
    agentName: agentName,
    role: "presentation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 15
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.fleet_integration.settings.apmAgent.description', {
    defaultMessage: 'Configure instrumentation for {title} applications.',
    values: {
      title
    }
  })))))));
}
function InstructionsContent({
  markdown
}) {
  return /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
    className: "euiText",
    readOnly: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, markdown);
}
const StyledEuiAccordion = (0, _styled.default)(_eui.EuiAccordion)`
  // This is an alternative fix suggested by the EUI team to fix drag elements inside EuiAccordion
  // This Issue tracks the fix on the Eui side https://github.com/elastic/eui/issues/3548#issuecomment-639041283
  .euiAccordion__childWrapper {
    transform: none;
  }
`;
function AgentInstructionsAccordion({
  agentName,
  title,
  createAgentInstructions,
  variantId,
  apmServerUrl,
  secretToken
}) {
  const docLinks = (0, _public.useKibana)().services.docLinks;
  const steps = createAgentInstructions(apmServerUrl, secretToken);
  const stepsElements = steps.map(({
    title: stepTitle,
    textPre,
    textPost,
    customComponentName,
    commands
  }, index) => {
    const commandBlock = commands ? (0, _render_mustache.renderMustache)({
      text: commands,
      docLinks
    }) : '';
    return /*#__PURE__*/_react.default.createElement("section", {
      key: index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }, stepTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }, textPre && /*#__PURE__*/_react.default.createElement(InstructionsContent, {
      markdown: (0, _render_mustache.renderMustache)({
        text: textPre,
        docLinks
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 15
      }
    }), commandBlock && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "bash",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 17
      }
    }, commandBlock)), customComponentName === 'TutorialConfigAgent' && /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: variantId,
      apmServerUrl: apmServerUrl,
      secretToken: secretToken,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    }), customComponentName === 'TutorialConfigAgentRumScript' && /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: "js_script",
      apmServerUrl: apmServerUrl,
      secretToken: secretToken,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 15
      }
    }), textPost && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(InstructionsContent, {
      markdown: (0, _render_mustache.renderMustache)({
        text: textPost,
        docLinks
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }));
  });
  return /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: agentName,
    buttonContent: /*#__PURE__*/_react.default.createElement(AccordionButtonContent, {
      agentName: agentName,
      title: title,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 22
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), stepsElements);
}