"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INSTRUCTION_VARIANT = void 0;
exports.getDisplayText = getDisplayText;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let INSTRUCTION_VARIANT = exports.INSTRUCTION_VARIANT = /*#__PURE__*/function (INSTRUCTION_VARIANT) {
  INSTRUCTION_VARIANT["NODE"] = "node";
  INSTRUCTION_VARIANT["DJANGO"] = "django";
  INSTRUCTION_VARIANT["FLASK"] = "flask";
  INSTRUCTION_VARIANT["RAILS"] = "rails";
  INSTRUCTION_VARIANT["RACK"] = "rack";
  INSTRUCTION_VARIANT["GO"] = "go";
  INSTRUCTION_VARIANT["JAVA"] = "java";
  INSTRUCTION_VARIANT["DOTNET"] = "dotnet";
  INSTRUCTION_VARIANT["PHP"] = "php";
  return INSTRUCTION_VARIANT;
}({});
const DISPLAY_MAP = {
  [INSTRUCTION_VARIANT.NODE]: 'Node.js',
  [INSTRUCTION_VARIANT.DJANGO]: 'Django',
  [INSTRUCTION_VARIANT.FLASK]: 'Flask',
  [INSTRUCTION_VARIANT.RAILS]: 'Ruby on Rails',
  [INSTRUCTION_VARIANT.RACK]: 'Rack',
  [INSTRUCTION_VARIANT.GO]: 'Go',
  [INSTRUCTION_VARIANT.JAVA]: 'Java',
  [INSTRUCTION_VARIANT.DOTNET]: '.NET',
  [INSTRUCTION_VARIANT.PHP]: 'PHP'
};
function getDisplayText(id) {
  return id in DISPLAY_MAP ? DISPLAY_MAP[id] : id;
}