"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionsChart = SessionsChart;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _timeseries_chart_with_context = require("../../../shared/charts/timeseries_chart_with_context");
var _get_comparison_chart_theme = require("../../../shared/time_comparison/get_comparison_chart_theme");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _use_previous_period_text = require("../../../../hooks/use_previous_period_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/charts/sessions_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INITIAL_STATE = {
  currentPeriod: {
    timeseries: []
  },
  previousPeriod: {
    timeseries: []
  }
};
function SessionsChart({
  kuery,
  serviceName,
  start,
  end,
  transactionType,
  transactionName,
  environment,
  offset,
  comparisonEnabled
}) {
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const {
    currentPeriodColor,
    previousPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.SESSIONS);
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/mobile-services/{serviceName}/transactions/charts/sessions', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          start,
          end,
          transactionType,
          transactionName,
          offset: comparisonEnabled ? offset : undefined
        }
      }
    });
  }, [environment, kuery, serviceName, start, end, transactionType, transactionName, offset, comparisonEnabled]);
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const timeseries = [{
    data: data.currentPeriod.timeseries,
    type: 'linemark',
    color: currentPeriodColor,
    title: _i18n.i18n.translate('xpack.apm.transactions.sessionsChartTitle', {
      defaultMessage: 'Sessions'
    })
  }, ...(comparisonEnabled ? [{
    data: data.previousPeriod.timeseries,
    type: 'area',
    color: previousPeriodColor,
    title: previousPeriodLabel
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.transactions.sessionsChartTitle', {
    defaultMessage: 'Sessions'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.apm.transactions.sessionsCharTooltip', {
      defaultMessage: 'Unique sessions id'
    }),
    position: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    id: "sessions",
    showAnnotations: false,
    fetchStatus: status,
    timeseries: timeseries,
    customTheme: comparisonChartTheme,
    yLabelFormat: y => `${y}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }));
}