"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigForDocumentType = getConfigForDocumentType;
exports.getDatasetFilterForSchema = getDatasetFilterForSchema;
exports.getMetricsetNameForDocumentType = getMetricsetNameForDocumentType;
exports.getProcessorEventForDocumentType = getProcessorEventForDocumentType;
var _apmTypesShared = require("@kbn/apm-types-shared");
var _term_query = require("@kbn/observability-utils-common/es/queries/term_query");
var _es_fields = require("@kbn/apm-types/es_fields");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
var _get_is_using_service_destination_metrics = require("../spans/get_is_using_service_destination_metrics");
var _transactions = require("../transactions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultRollupIntervals = [_rollup.RollupInterval.OneMinute, _rollup.RollupInterval.TenMinutes, _rollup.RollupInterval.SixtyMinutes];
function getDefaultFilter(metricsetName, rollupInterval) {
  return [...(0, _term_query.termQuery)(_es_fields.METRICSET_NAME, metricsetName), ...(0, _term_query.termQuery)(_es_fields.METRICSET_INTERVAL, rollupInterval)];
}
const documentTypeConfigMap = {
  [_document_type.ApmDocumentType.ServiceTransactionMetric]: {
    processorEvent: _apmTypesShared.ProcessorEvent.metric,
    metricsetName: 'service_transaction',
    getQuery: rollupInterval => ({
      bool: {
        filter: getDefaultFilter('service_transaction', rollupInterval)
      }
    }),
    rollupIntervals: defaultRollupIntervals
  },
  [_document_type.ApmDocumentType.ServiceSummaryMetric]: {
    processorEvent: _apmTypesShared.ProcessorEvent.metric,
    metricsetName: 'service_summary',
    getQuery: rollupInterval => ({
      bool: {
        filter: getDefaultFilter('service_summary', rollupInterval)
      }
    }),
    rollupIntervals: defaultRollupIntervals
  },
  [_document_type.ApmDocumentType.TransactionMetric]: {
    processorEvent: _apmTypesShared.ProcessorEvent.metric,
    metricsetName: 'transaction',
    getQuery: rollupInterval => ({
      bool: {
        filter: rollupInterval === _rollup.RollupInterval.OneMinute ? (0, _transactions.getBackwardCompatibleDocumentTypeFilter)(true) : getDefaultFilter('transaction', rollupInterval)
      }
    }),
    rollupIntervals: defaultRollupIntervals
  },
  [_document_type.ApmDocumentType.TransactionEvent]: {
    processorEvent: _apmTypesShared.ProcessorEvent.transaction,
    rollupIntervals: [_rollup.RollupInterval.None]
  },
  [_document_type.ApmDocumentType.ServiceDestinationMetric]: {
    processorEvent: _apmTypesShared.ProcessorEvent.metric,
    metricsetName: 'service_destination',
    rollupIntervals: defaultRollupIntervals,
    getQuery: rollupInterval => ({
      bool: {
        filter: rollupInterval === _rollup.RollupInterval.OneMinute ? (0, _get_is_using_service_destination_metrics.getDocumentTypeFilterForServiceDestinationStatistics)(true) : getDefaultFilter('service_destination', rollupInterval)
      }
    })
  },
  [_document_type.ApmDocumentType.ErrorEvent]: {
    processorEvent: _apmTypesShared.ProcessorEvent.error,
    rollupIntervals: [_rollup.RollupInterval.None]
  },
  [_document_type.ApmDocumentType.SpanEvent]: {
    processorEvent: _apmTypesShared.ProcessorEvent.span,
    rollupIntervals: [_rollup.RollupInterval.None]
  }
};
function getConfigForDocumentType(docType) {
  return documentTypeConfigMap[docType];
}
function getProcessorEventForDocumentType(documentType) {
  return getConfigForDocumentType(documentType).processorEvent;
}
function getMetricsetNameForDocumentType(documentType) {
  const config = getConfigForDocumentType(documentType);
  return 'metricsetName' in config ? config.metricsetName : undefined;
}
function getDatasetFilterForSchema(documentType, rollupInterval, schema) {
  const metricsetName = getMetricsetNameForDocumentType(documentType);
  if (!metricsetName) {
    return [];
  }
  const datasetValue = `${schema === 'ecs' ? 'apm.' : ''}${metricsetName}.${rollupInterval}${schema === 'semconv' ? '.otel' : ''}`;
  return (0, _term_query.termQuery)(_common.DATASTREAM_DATASET, datasetValue);
}