"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformUpdateBodySystemActions = exports.transformUpdateBodyActions = exports.transformUpdateBody = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformUpdateBodyActions = actions => {
  if (!actions) {
    return [];
  }
  return actions.map(({
    group,
    id,
    params,
    frequency,
    uuid,
    alerts_filter: alertsFilter,
    use_alert_data_for_template: useAlertDataForTemplate
  }) => {
    return {
      group: group !== null && group !== void 0 ? group : 'default',
      id,
      params,
      ...(uuid ? {
        uuid
      } : {}),
      ...(typeof useAlertDataForTemplate !== 'undefined' ? {
        useAlertDataForTemplate
      } : {}),
      ...(frequency ? {
        frequency: {
          ...(0, _lodash.omit)(frequency, 'notify_when'),
          summary: frequency.summary,
          throttle: frequency.throttle,
          notifyWhen: frequency.notify_when
        }
      } : {}),
      ...(alertsFilter ? {
        alertsFilter
      } : {})
    };
  });
};
exports.transformUpdateBodyActions = transformUpdateBodyActions;
const transformUpdateBodySystemActions = actions => {
  if (!actions) {
    return [];
  }
  return actions.map(({
    id,
    params,
    uuid
  }) => {
    return {
      id,
      params,
      ...(uuid ? {
        uuid
      } : {})
    };
  });
};
exports.transformUpdateBodySystemActions = transformUpdateBodySystemActions;
const transformUpdateBodyFlapping = flapping => {
  if (!flapping) {
    return flapping;
  }
  return {
    enabled: flapping.enabled,
    lookBackWindow: flapping.look_back_window,
    statusChangeThreshold: flapping.status_change_threshold
  };
};
const transformUpdateBody = ({
  updateBody,
  actions,
  systemActions
}) => {
  return {
    name: updateBody.name,
    tags: updateBody.tags,
    ...(updateBody.throttle ? {
      throttle: updateBody.throttle
    } : {}),
    params: updateBody.params,
    schedule: updateBody.schedule,
    actions: transformUpdateBodyActions(actions),
    systemActions: transformUpdateBodySystemActions(systemActions),
    ...(updateBody.notify_when ? {
      notifyWhen: updateBody.notify_when
    } : {}),
    ...(updateBody.alert_delay ? {
      alertDelay: updateBody.alert_delay
    } : {}),
    ...(updateBody.flapping !== undefined ? {
      flapping: transformUpdateBodyFlapping(updateBody.flapping)
    } : {}),
    ...(updateBody.artifacts ? {
      artifacts: updateBody.artifacts
    } : {})
  };
};
exports.transformUpdateBody = transformUpdateBody;