"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkUnmuteAlertsRoute = void 0;
var _lib = require("../../../../lib");
var _lib2 = require("../../../lib");
var _types = require("../../../../types");
var _bulk_mute_unmute = require("../../../../../common/routes/rule/apis/bulk_mute_unmute");
var _constants = require("../../../constants");
var _validation = require("../../validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkUnmuteAlertsRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/alerts/_bulk_unmute`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal',
      summary: `Bulk unmute alerts`
    },
    validate: {
      body: _bulk_mute_unmute.bulkMuteUnmuteAlertsBodySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const body = req.body;
    (0, _validation.validateMaxMuteUnmuteInstancesV1)(body);
    const args = (0, _bulk_mute_unmute.transformBulkMuteUnmuteAlertsBodyV1)(body);
    try {
      await rulesClient.bulkUnmuteInstances({
        rules: args
      });
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.bulkUnmuteAlertsRoute = bulkUnmuteAlertsRoute;