"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRequest = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRequest = request => {
  const body = request.body;
  const params = request.params;
  return {
    id: params.id,
    request,
    name: body.name,
    enabled: body.enabled,
    gapFillRange: body.gap_fill_range,
    maxBackfills: body.max_backfills,
    numRetries: body.num_retries,
    schedule: body.schedule,
    scope: body.scope,
    ruleTypes: body.rule_types.map(ruleType => ({
      type: ruleType.type,
      consumer: ruleType.consumer
    }))
  };
};
exports.transformRequest = transformRequest;