"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OUTDATED_TASK_VERSION = exports.ErrorWithType = exports.CLUSTER_BLOCK_EXCEPTION = void 0;
exports.getErrorType = getErrorType;
exports.isClusterBlockError = isClusterBlockError;
exports.isErrorWithType = isErrorWithType;
exports.isOutdatedTaskVersionError = isOutdatedTaskVersionError;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CLUSTER_BLOCK_EXCEPTION = exports.CLUSTER_BLOCK_EXCEPTION = 'cluster_block_exception';
const OUTDATED_TASK_VERSION = exports.OUTDATED_TASK_VERSION = 'outdated_task_version';
class ErrorWithType extends Error {
  constructor({
    type,
    message = 'Unknown error',
    stack
  }) {
    super(message);
    (0, _defineProperty2.default)(this, "type", void 0);
    this.type = type;
    this.stack = stack;
  }
}
exports.ErrorWithType = ErrorWithType;
function getErrorType(error) {
  if (isErrorWithType(error)) {
    return error.type;
  }
}
function isErrorWithType(error) {
  return error instanceof ErrorWithType;
}
function isClusterBlockError(err) {
  return getErrorType(err) === CLUSTER_BLOCK_EXCEPTION;
}
function isOutdatedTaskVersionError(err) {
  return getErrorType(err) === OUTDATED_TASK_VERSION;
}