"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listRuleTypes = listRuleTypes;
var _authorization = require("../../../../authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function listRuleTypes(context) {
  const registeredRuleTypes = context.ruleTypeRegistry.list();
  const authorizedRuleTypes = await context.authorization.getAuthorizedRuleTypes({
    authorizationEntity: _authorization.AlertingAuthorizationEntity.Rule,
    operations: [_authorization.ReadOperations.Get, _authorization.WriteOperations.Create],
    ruleTypeIds: Array.from(registeredRuleTypes.keys()).map(id => id)
  });
  return Array.from(authorizedRuleTypes.entries()).filter(([id, _]) => context.ruleTypeRegistry.has(id)).map(([id, {
    authorizedConsumers
  }]) => ({
    ...registeredRuleTypes.get(id),
    authorizedConsumers
  }));
}