"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInactiveAlertsQuery = exports.getActiveAlertsQuery = void 0;
var _esQuery = require("@kbn/es-query");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActiveAlertsQuery = (threshold, spaceId) => {
  const filterClauses = [`kibana.alert.status: "active"`, `kibana.alert.start < "now-${threshold}d"`, `NOT kibana.alert.end:*`, `NOT kibana.alert.workflow_status_updated_at:*`, `NOT kibana.alert.case_ids:*`, `${[_ruleDataUtils.SPACE_IDS]}: ${spaceId}`];
  const filterKueryNode = (0, _esQuery.fromKueryExpression)(filterClauses.join(' AND '));
  return (0, _esQuery.toElasticsearchQuery)(filterKueryNode);
};
exports.getActiveAlertsQuery = getActiveAlertsQuery;
const getInactiveAlertsQuery = (threshold, spaceId) => {
  const closedFilter = `(kibana.alert.workflow_status: "closed" OR kibana.alert.workflow_status: "acknowledged")`;
  const closedThreshold = `kibana.alert.workflow_status_updated_at < "now-${threshold}d"`;
  const inactiveFilter = `(kibana.alert.status: "untracked" OR kibana.alert.status: "recovered")`;
  const inactiveThreshold = `kibana.alert.end < "now-${threshold}d"`;
  const filterClauses = [`((${closedFilter} AND ${closedThreshold}) OR (${inactiveFilter} AND ${inactiveThreshold}))`, `NOT kibana.alert.case_ids:*`, `${[_ruleDataUtils.SPACE_IDS]}: ${spaceId}`];
  const filterKueryNode = (0, _esQuery.fromKueryExpression)(filterClauses.join(' AND '));
  return (0, _esQuery.toElasticsearchQuery)(filterKueryNode);
};
exports.getInactiveAlertsQuery = getInactiveAlertsQuery;