"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGapAutoFillSchedulerParamsSchema = exports.gapAutoFillSchedulerUpdateBodySchema = exports.gapAutoFillSchedulerResponseSchema = exports.gapAutoFillSchedulerLogsResponseSchema = exports.gapAutoFillSchedulerLogsRequestQuerySchema = exports.gapAutoFillSchedulerLogEntrySchema = exports.gapAutoFillSchedulerBodySchema = exports.findGapAutoFillSchedulerLogsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _constants = require("../../../../../constants");
var _parse_duration = require("../../../../../parse_duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  maxBackfills,
  numRetries,
  minScheduleIntervalInMs
} = _constants.gapAutoFillSchedulerLimits;
const validateGapAutoFillSchedulerPayload = (gapFillRange, schedule, ruleTypes) => {
  const now = new Date();
  const parsed = _datemath.default.parse(gapFillRange, {
    forceNow: now
  });
  if (!parsed || !parsed.isValid()) {
    return 'gap_fill_range is invalid';
  }
  const maxLookbackExpression = `now-${_constants.MAX_SCHEDULE_BACKFILL_LOOKBACK_WINDOW_DAYS}d`;
  const lookbackLimit = _datemath.default.parse(maxLookbackExpression, {
    forceNow: now
  });
  if (!lookbackLimit || !lookbackLimit.isValid()) {
    return 'gap_fill_range is invalid';
  }
  if (parsed.isBefore(lookbackLimit)) {
    return `gap_fill_range cannot look back more than ${_constants.MAX_SCHEDULE_BACKFILL_LOOKBACK_WINDOW_DAYS} days`;
  }
  try {
    const intervalMs = (0, _parse_duration.parseDuration)(schedule.interval);
    if (intervalMs < minScheduleIntervalInMs) {
      return 'schedule.interval must be at least 1 minute';
    }
  } catch (error) {
    return `schedule.interval is invalid: ${error.message}`;
  }

  // Duplicate check for rule_types
  const seen = new Set();
  for (const ruleType of ruleTypes) {
    const key = `${ruleType.type}:${ruleType.consumer}`;
    if (seen.has(key)) {
      return `rule_types contains duplicate entry: type="${ruleType.type}" consumer="${ruleType.consumer}"`;
    }
    seen.add(key);
  }
};
const getGapAutoFillSchedulerParamsSchema = exports.getGapAutoFillSchedulerParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const gapAutoFillSchedulerBodySchema = exports.gapAutoFillSchedulerBodySchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  name: _configSchema.schema.string({
    defaultValue: ''
  }),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  max_backfills: _configSchema.schema.number(maxBackfills),
  num_retries: _configSchema.schema.number(numRetries),
  gap_fill_range: _configSchema.schema.string({
    defaultValue: 'now-90d'
  }),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  scope: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  rule_types: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    consumer: _configSchema.schema.string()
  }))
}, {
  validate(payload) {
    return validateGapAutoFillSchedulerPayload(payload.gap_fill_range, payload.schedule, payload.rule_types);
  }
});
const gapAutoFillSchedulerUpdateBodySchema = exports.gapAutoFillSchedulerUpdateBodySchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  gap_fill_range: _configSchema.schema.string(),
  max_backfills: _configSchema.schema.number(maxBackfills),
  num_retries: _configSchema.schema.number(numRetries),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  scope: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  rule_types: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    consumer: _configSchema.schema.string()
  }))
}, {
  validate(payload) {
    return validateGapAutoFillSchedulerPayload(payload.gap_fill_range, payload.schedule, payload.rule_types);
  }
});
const gapAutoFillSchedulerResponseSchema = exports.gapAutoFillSchedulerResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string()
  }),
  rule_types: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    consumer: _configSchema.schema.string()
  })),
  gap_fill_range: _configSchema.schema.string(),
  max_backfills: _configSchema.schema.number(),
  num_retries: _configSchema.schema.number(),
  scope: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  created_by: _configSchema.schema.nullable(_configSchema.schema.string()),
  updated_by: _configSchema.schema.nullable(_configSchema.schema.string()),
  created_at: _configSchema.schema.string(),
  updated_at: _configSchema.schema.string()
});
const gapAutoFillSchedulerLogsRequestQuerySchema = exports.gapAutoFillSchedulerLogsRequestQuerySchema = _configSchema.schema.object({
  start: _configSchema.schema.string(),
  end: _configSchema.schema.string(),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  per_page: _configSchema.schema.number({
    defaultValue: 50,
    min: 1,
    max: 1000
  }),
  sort_field: _configSchema.schema.oneOf([_configSchema.schema.literal('@timestamp')], {
    defaultValue: '@timestamp'
  }),
  sort_direction: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
    defaultValue: 'desc'
  }),
  statuses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('success'), _configSchema.schema.literal('error'), _configSchema.schema.literal('skipped'), _configSchema.schema.literal('no_gaps')])))
}, {
  validate({
    start,
    end
  }) {
    const parsedStart = Date.parse(start);
    if (isNaN(parsedStart)) {
      return `[start]: query start must be valid date`;
    }
    const parsedEnd = Date.parse(end);
    if (isNaN(parsedEnd)) {
      return `[end]: query end must be valid date`;
    }
  }
});
const gapAutoFillSchedulerLogEntrySchema = exports.gapAutoFillSchedulerLogEntrySchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  timestamp: _configSchema.schema.maybe(_configSchema.schema.string()),
  status: _configSchema.schema.maybe(_configSchema.schema.string()),
  message: _configSchema.schema.maybe(_configSchema.schema.string()),
  results: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    rule_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    processed_gaps: _configSchema.schema.maybe(_configSchema.schema.number()),
    status: _configSchema.schema.maybe(_configSchema.schema.string()),
    error: _configSchema.schema.maybe(_configSchema.schema.string())
  })))
});
const gapAutoFillSchedulerLogsResponseSchema = exports.gapAutoFillSchedulerLogsResponseSchema = _configSchema.schema.object({
  data: _configSchema.schema.arrayOf(gapAutoFillSchedulerLogEntrySchema),
  total: _configSchema.schema.number(),
  page: _configSchema.schema.number(),
  per_page: _configSchema.schema.number()
});
const findGapAutoFillSchedulerLogsParamsSchema = exports.findGapAutoFillSchedulerLogsParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});