"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsFilterQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsFilterQuerySchema = exports.alertsFilterQuerySchema = _configSchema.schema.object({
  kql: _configSchema.schema.string({
    meta: {
      description: 'A filter written in Kibana Query Language (KQL).'
    }
  }),
  filters: _configSchema.schema.arrayOf(_configSchema.schema.object({
    query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any({
      meta: {
        description: 'A query for the filter.'
      }
    }))),
    meta: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any({
      meta: {
        description: 'An object with fields such as "controlledBy", "disabled", "field", "group", "index", "isMultiIndex", "key", "negate", "params",  "type", "value"'
      }
    })),
    $state: _configSchema.schema.maybe(_configSchema.schema.object({
      store: _configSchema.schema.oneOf([_configSchema.schema.literal(_esQuery.FilterStateStore.APP_STATE), _configSchema.schema.literal(_esQuery.FilterStateStore.GLOBAL_STATE)], {
        meta: {
          description: 'A filter can be either specific to an application context or applied globally.'
        }
      })
    }))
  }), {
    meta: {
      description: 'A filter written in Elasticsearch Query Domain Specific Language (DSL) as defined in the `kbn-es-query` package.'
    }
  }),
  dsl: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'A filter written in Elasticsearch Query Domain Specific Language (DSL).'
    }
  }))
});