"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternAnalysisEmbeddableWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_data_source = require("../../hooks/use_data_source");
var _log_categorization_for_embeddable = _interopRequireDefault(require("../../components/log_categorization/log_categorization_for_embeddable/log_categorization_for_embeddable"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/embeddables/pattern_analysis/pattern_analysis_component_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Grid component wrapper for embeddable.
 *
 * @param fieldName
 * @param minimumTimeRangeOption
 * @param randomSamplerMode
 * @param randomSamplerProbability
 * @param lastReloadRequestTime
 * @param onError
 * @param onLoading
 * @param onRenderComplete
 * @param onChange
 * @param emptyState
 * @param timeRange
 * @constructor
 */
const PatternAnalysisEmbeddableWrapper = ({
  dataViewId,
  fieldName,
  minimumTimeRangeOption,
  randomSamplerMode,
  randomSamplerProbability,
  lastReloadRequestTime,
  onError,
  onLoading,
  onRenderComplete,
  onChange,
  emptyState,
  timeRange
}) => {
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  if (dataView.id !== dataViewId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: '100%',
      height: '100%',
      overflowY: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_log_categorization_for_embeddable.default, {
    dataView: dataView,
    dataViewId: dataView.id,
    fieldName: fieldName,
    minimumTimeRangeOption: minimumTimeRangeOption,
    randomSamplerProbability: randomSamplerProbability,
    randomSamplerMode: randomSamplerMode,
    lastReloadRequestTime: lastReloadRequestTime,
    timeRange: timeRange,
    onError: onError,
    onLoading: onLoading,
    onRenderComplete: onRenderComplete,
    onChange: onChange,
    emptyState: emptyState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
};
exports.PatternAnalysisEmbeddableWrapper = PatternAnalysisEmbeddableWrapper;