"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformIn = transformIn;
var _common = require("@kbn/data-views-plugin/common");
var _constants = require("@kbn/aiops-log-pattern-analysis/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformIn(state) {
  const {
    dataViewId,
    ...rest
  } = state;
  return {
    state: rest,
    references: dataViewId ? [{
      type: _common.DATA_VIEW_SAVED_OBJECT_TYPE,
      name: _constants.PATTERN_ANALYSIS_DATA_VIEW_REF_NAME,
      id: dataViewId
    }] : []
  };
}