"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _ai_assistant_type = require("../common/ai_assistant_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  preferredAIAssistantType: _configSchema.schema.oneOf([_configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Default), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Never), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Observability), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Security)], {
    defaultValue: _ai_assistant_type.AIAssistantType.Default
  }),
  preferredChatExperience: _configSchema.schema.oneOf([_configSchema.schema.literal(_aiAssistantCommon.AIChatExperience.Classic), _configSchema.schema.literal(_aiAssistantCommon.AIChatExperience.Agent)], {
    defaultValue: _aiAssistantCommon.AIChatExperience.Classic
  })
});
const config = exports.config = {
  schema: configSchema,
  exposeToBrowser: {
    preferredAIAssistantType: true,
    preferredChatExperience: true
  }
};