"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customHostSettingsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const customHostSettingsSchema = exports.customHostSettingsSchema = _configSchema.schema.object({
  url: _configSchema.schema.string({
    minLength: 1
  }),
  smtp: _configSchema.schema.maybe(_configSchema.schema.object({
    ignoreTLS: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    requireTLS: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })),
  ssl: _configSchema.schema.maybe(_configSchema.schema.object({
    verificationMode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('none'), _configSchema.schema.literal('certificate'), _configSchema.schema.literal('full')], {
      defaultValue: 'full'
    })),
    certificateAuthoritiesFiles: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string({
      minLength: 1
    }), _configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1
    })])),
    certificateAuthoritiesData: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1
    }))
  }))
});