"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LazyServiceIdentifier = void 0;
const islazyServiceIdentifierSymbol = Symbol.for('@inversifyjs/common/islazyServiceIdentifier');
class LazyServiceIdentifier {
    [islazyServiceIdentifierSymbol];
    #buildServiceId;
    constructor(buildServiceId) {
        this.#buildServiceId = buildServiceId;
        this[islazyServiceIdentifierSymbol] = true;
    }
    static is(value) {
        return (typeof value === 'object' &&
            value !== null &&
            value[islazyServiceIdentifierSymbol] === true);
    }
    unwrap() {
        return this.#buildServiceId();
    }
}
exports.LazyServiceIdentifier = LazyServiceIdentifier;
//# sourceMappingURL=LazyServiceIdentifier.js.map