"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSideNavMobileStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "f0todx-euiSideNav__mobileToggleContent",
  styles: "justify-content:space-between;label:euiSideNav__mobileToggleContent;"
} : {
  name: "f0todx-euiSideNav__mobileToggleContent",
  styles: "justify-content:space-between;label:euiSideNav__mobileToggleContent;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiSideNavMobileStyles = exports.euiSideNavMobileStyles = function euiSideNavMobileStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var fastTransition = "".concat(euiTheme.animation.extraFast, " ").concat(euiTheme.animation.resistance);
  var slowTransition = "".concat(euiTheme.animation.extraSlow, " ").concat(euiTheme.animation.resistance);
  return {
    // Mobile button
    euiSideNav__mobileToggle: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('height', 'auto'), "padding:1em;font-size:inherit;text-align:start;border-radius:0;", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), ";;label:euiSideNav__mobileToggle;"),
    euiSideNav__mobileToggleContent: _ref,
    // Mobile content
    content: {
      euiSideNav__mobileContent: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{transition:max-block-size ", fastTransition, ",padding-block ", fastTransition, ",opacity ", slowTransition, ",visibility ", slowTransition, ";};label:euiSideNav__mobileContent;"),
      hidden: /*#__PURE__*/(0, _react.css)("overflow:hidden;visibility:hidden;opacity:0;max-block-size:0;padding-inline:", euiTheme.size.l, ";;label:hidden;"),
      open: /*#__PURE__*/(0, _react.css)("visibility:visible;opacity:1;max-block-size:5000px;padding:", euiTheme.size.l, ";;label:open;")
    }
  };
};