"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiOverlayMaskStyles = void 0;
var _css = require("@emotion/css");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiOverlayMaskStyles = exports.euiOverlayMaskStyles = function euiOverlayMaskStyles(_ref) {
  var euiTheme = _ref.euiTheme,
    highContrastMode = _ref.highContrastMode;
  return {
    euiOverlayMask: /*#__PURE__*/(0, _css.css)("position:fixed;", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('right', 0), " ", (0, _global_styling.logicalCSS)('bottom', 0), " display:flex;align-items:center;justify-content:center;animation:", _global_styling.euiAnimFadeIn, " ", euiTheme.animation.fast, " ease-in forwards;animation-iteration-count:1;background:", highContrastMode ? euiTheme.components.overlayMaskBackgroundHighContrast : euiTheme.components.overlayMaskBackground, ";;label:euiOverlayMask;"),
    aboveHeader: /*#__PURE__*/(0, _css.css)("z-index:", euiTheme.levels.mask, ";;label:aboveHeader;"),
    belowHeader: /*#__PURE__*/(0, _css.css)("z-index:", euiTheme.levels.maskBelowHeader, ";", (0, _global_styling.logicalCSS)('top', 'var(--euiFixedHeadersOffset, 0)'), ";;label:belowHeader;"),
    noAnimation: /*#__PURE__*/(0, _css.css)(process.env.NODE_ENV === "production" ? {
      name: "lqr4xc-noAnimation",
      styles: "animation:none;label:noAnimation;"
    } : {
      name: "lqr4xc-noAnimation",
      styles: "animation:none;label:noAnimation;",
      toString: _EMOTION_STRINGIFIED_CSS_ERROR__
    })
  };
};