"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMarkdownEditorHelpButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _button = require("../button");
var _title = require("../title");
var _modal = require("../modal");
var _i18n = require("../i18n");
var _popover = require("../popover");
var _text = require("../text");
var _spacer = require("../spacer");
var _tool_tip = require("../tool_tip");
var _horizontal_rule = require("../horizontal_rule");
var _link = require("../link");
var _markdown_context = require("./markdown_context");
var _markdown_logo = _interopRequireDefault(require("./icons/markdown_logo"));
var _markdown_editor_help_button = require("./markdown_editor_help_button.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // @ts-ignore a react svg
var mdSyntaxHref = 'https://guides.github.com/features/mastering-markdown/';
var mdSyntaxLink = (0, _react2.jsx)(_link.EuiLink, {
  href: mdSyntaxHref,
  target: "_blank"
}, (0, _react2.jsx)(_i18n.EuiI18n, {
  token: "euiMarkdownEditorHelpButton.mdSyntaxLink",
  default: "GitHub flavored markdown"
}));
var EuiMarkdownEditorHelpButton = exports.EuiMarkdownEditorHelpButton = function EuiMarkdownEditorHelpButton(_ref) {
  var uiPlugins = _ref.uiPlugins;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isShowingHelpModal = _useState2[0],
    setIsShowingHelpModal = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isShowingHelpPopover = _useState4[0],
    setIsShowingHelpPopover = _useState4[1];
  var _useContext = (0, _react.useContext)(_markdown_context.EuiMarkdownContext),
    readOnly = _useContext.readOnly;
  var styles = (0, _services.useEuiMemoizedStyles)(_markdown_editor_help_button.euiMarkdownEditorHelpButtonStyles);
  var syntaxTitle = (0, _i18n.useEuiI18n)('euiMarkdownEditorHelpButton.syntaxTitle', 'Syntax help');
  var ariaLabels = {
    showMarkdownHelp: (0, _i18n.useEuiI18n)('euiMarkdownEditorHelpButton.showMarkdownHelp', 'Show markdown help')
  };
  var helpModalTitleId = (0, _services.useGeneratedHtmlId)();
  var uiPluginsWithHelpText = uiPlugins.filter(function (_ref2) {
    var helpText = _ref2.helpText;
    return !!helpText;
  });
  var hasUiPluginsWithHelpText = uiPluginsWithHelpText.length > 0;
  if (hasUiPluginsWithHelpText) {
    return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      content: syntaxTitle
    }, (0, _react2.jsx)(_button.EuiButtonIcon, {
      size: "s",
      css: styles.euiMarkdownEditorFooter__helpButton,
      className: "euiMarkdownEditorFooter__helpButton",
      iconType: _markdown_logo.default,
      color: "text",
      "aria-label": ariaLabels.showMarkdownHelp,
      onClick: function onClick() {
        return setIsShowingHelpModal(!isShowingHelpModal);
      },
      isDisabled: readOnly
    })), isShowingHelpModal && (0, _react2.jsx)(_modal.EuiModal, {
      onClose: function onClose() {
        return setIsShowingHelpModal(false);
      },
      "aria-labelledby": helpModalTitleId
    }, (0, _react2.jsx)(_modal.EuiModalHeader, null, (0, _react2.jsx)(_title.EuiTitle, null, (0, _react2.jsx)("h1", {
      id: helpModalTitleId
    }, syntaxTitle))), (0, _react2.jsx)(_modal.EuiModalBody, null, (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)(_i18n.EuiI18n, {
      tokens: ['euiMarkdownEditorHelpButton.syntaxModalDescriptionPrefix', 'euiMarkdownEditorHelpButton.syntaxModalDescriptionSuffix'],
      defaults: ['This editor uses', 'You can also utilize these additional syntax plugins to add rich content to your text.']
    }, function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        syntaxModalDescriptionPrefix = _ref4[0],
        syntaxModalDescriptionSuffix = _ref4[1];
      return (0, _react2.jsx)("p", null, syntaxModalDescriptionPrefix, " ", mdSyntaxLink, ".", ' ', syntaxModalDescriptionSuffix);
    })), (0, _react2.jsx)(_horizontal_rule.EuiHorizontalRule, null), uiPluginsWithHelpText.map(function (_ref5) {
      var name = _ref5.name,
        helpText = _ref5.helpText;
      return (0, _react2.jsx)(_react.Fragment, {
        key: name
      }, (0, _react2.jsx)(_title.EuiTitle, {
        size: "xxs"
      }, (0, _react2.jsx)("p", null, (0, _react2.jsx)("strong", null, name))), (0, _react2.jsx)(_spacer.EuiSpacer, {
        size: "s"
      }), helpText, (0, _react2.jsx)(_spacer.EuiSpacer, {
        size: "l"
      }));
    }), (0, _react2.jsx)(_horizontal_rule.EuiHorizontalRule, null)), (0, _react2.jsx)(_modal.EuiModalFooter, null, (0, _react2.jsx)(_button.EuiButton, {
      onClick: function onClick() {
        return setIsShowingHelpModal(false);
      },
      fill: true
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiMarkdownEditorHelpButton.closeButton",
      default: "Close"
    })))));
  } else {
    return (0, _react2.jsx)(_popover.EuiPopover, {
      button: (0, _react2.jsx)(_button.EuiButtonIcon, {
        title: syntaxTitle,
        size: "s",
        css: styles.euiMarkdownEditorFooter__helpButton,
        className: "euiMarkdownEditorFooter__helpButton",
        iconType: _markdown_logo.default,
        color: "text",
        "aria-label": ariaLabels.showMarkdownHelp,
        onClick: function onClick() {
          return setIsShowingHelpPopover(!isShowingHelpPopover);
        }
      }),
      isOpen: isShowingHelpPopover,
      closePopover: function closePopover() {
        return setIsShowingHelpPopover(false);
      },
      panelPaddingSize: "s",
      anchorPosition: "upCenter",
      "aria-labelledby": helpModalTitleId
    }, (0, _react2.jsx)(_i18n.EuiI18n, {
      tokens: ['euiMarkdownEditorHelpButton.syntaxPopoverDescription'],
      defaults: ['This editor uses']
    }, function (_ref6) {
      var _ref7 = _slicedToArray(_ref6, 1),
        syntaxPopoverDescription = _ref7[0];
      return (0, _react2.jsx)("p", null, syntaxPopoverDescription, " ", mdSyntaxLink, ".");
    }));
  }
};
EuiMarkdownEditorHelpButton.displayName = 'EuiMarkdownEditorHelpButton';