"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutManager = exports.EuiFlyoutManagerContext = exports.EuiFlyoutManager = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shim = require("use-sync-external-store/shim");
var _layout_mode = require("./layout_mode");
var _store = require("./store");
var _react2 = require("@emotion/react");
var _excluded = ["getState", "subscribe"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * React context that exposes the Flyout Manager API (state + actions).
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFlyoutManagerContext = exports.EuiFlyoutManagerContext = /*#__PURE__*/(0, _react.createContext)(null);

/**
 * Provides the Flyout Manager API via context and runs layout-mode logic.
 */
var EuiFlyoutManager = exports.EuiFlyoutManager = function EuiFlyoutManager(_ref) {
  var children = _ref.children;
  var _getFlyoutManagerStor = (0, _store.getFlyoutManagerStore)(),
    getState = _getFlyoutManagerStor.getState,
    subscribe = _getFlyoutManagerStor.subscribe,
    rest = _objectWithoutProperties(_getFlyoutManagerStor, _excluded);
  var state = (0, _shim.useSyncExternalStore)(subscribe, getState, getState);
  var api = (0, _react.useMemo)(function () {
    return _objectSpread({
      state: state
    }, rest);
  }, [state, rest]);
  return (0, _react2.jsx)(EuiFlyoutManagerContext.Provider, {
    value: api
  }, (0, _react2.jsx)(EuiFlyoutManagerContainer, null, children));
};
var EuiFlyoutManagerContainer = function EuiFlyoutManagerContainer(_ref2) {
  var children = _ref2.children;
  (0, _layout_mode.useApplyFlyoutLayoutMode)();
  return (0, _react2.jsx)(_react.default.Fragment, null, children);
};

/** Hook to access the Flyout Manager API from context. */
var useFlyoutManager = exports.useFlyoutManager = function useFlyoutManager() {
  return (0, _react.useContext)(EuiFlyoutManagerContext);
};