"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCallOutStyles = exports.euiCallOutHeaderStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "173v8a4-euiCallOut__dismissButton",
  styles: "position:absolute;label:euiCallOut__dismissButton;"
} : {
  name: "173v8a4-euiCallOut__dismissButton",
  styles: "position:absolute;label:euiCallOut__dismissButton;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "192kin0-euiCallOut",
  styles: "position:relative;label:euiCallOut;"
} : {
  name: "192kin0-euiCallOut",
  styles: "position:relative;label:euiCallOut;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCallOutStyles = exports.euiCallOutStyles = function euiCallOutStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiCallOut: _ref2,
    hasDismissButton: {
      // Ensure that only the top-most (first-child) title or child text
      // has a padding-right on it (to account for the dismiss button)
      hasDimissButton: /*#__PURE__*/(0, _react.css)("&>:first-child:is(.euiTitle),&>:first-child:is(.euiText)>:first-child{", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.base), ";};label:hasDimissButton;"),
      // Ensure the callout always has enough height for the button
      s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-height', euiTheme.size.xl), ";;label:s;"),
      m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-height', euiTheme.size.xxl), ";;label:m;")
    },
    dismissButton: {
      euiCallOut__dismissButton: _ref,
      s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('right', euiTheme.size.xs), ";;label:s;"),
      m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('right', euiTheme.size.s), ";;label:m;")
    }
  };
};
var euiCallOutHeaderStyles = exports.euiCallOutHeaderStyles = function euiCallOutHeaderStyles(_ref4) {
  var euiTheme = _ref4.euiTheme;
  return {
    euiCallOutHeader: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.medium, ";", (0, _global_styling.logicalCSS)('margin-bottom', '0 !important'
    // In case it's nested inside EuiText
    ), ";;label:euiCallOutHeader;"),
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textPrimary, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textSuccess, ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textWarning, ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textDanger, ";;label:danger;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textAccent, ";;label:accent;"),
    euiCallOut__icon: /*#__PURE__*/(0, _react.css)("position:relative;", (0, _global_styling.logicalCSS)('top', '-1px'), " ", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.s), ";;label:euiCallOut__icon;")
  };
};