"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTelemetryCounterHelper = createTelemetryCounterHelper;
var tslib_1 = require("tslib");
/**
 * Creates a telemetry counter helper to make it easier to generate them
 * @param telemetryCounter$ The observable that will be used to emit the telemetry counters
 * @param source The name of the shipper that is sending the events.
 */
function createTelemetryCounterHelper(telemetryCounter$, source) {
    /**
     * Triggers a telemetry counter for each event type.
     * @param events The events to trigger the telemetry counter for.
     * @param type The type of telemetry counter to trigger.
     * @param code The success or error code for additional detail about the result.
     * @param error The error that occurred, if any.
     */
    return function (events, _a) {
        var _b = _a === void 0 ? {} : _a, type = _b.type, code = _b.code, error = _b.error;
        var eventTypeCounts = countEventTypes(events);
        Object.entries(eventTypeCounts).forEach(function (_a) {
            var _b;
            var _c = tslib_1.__read(_a, 2), eventType = _c[0], count = _c[1];
            telemetryCounter$.next({
                source: source,
                type: type !== null && type !== void 0 ? type : (error ? 'failed' : 'succeeded'),
                code: (_b = code !== null && code !== void 0 ? code : error === null || error === void 0 ? void 0 : error.message) !== null && _b !== void 0 ? _b : 'OK',
                count: count,
                event_type: eventType,
            });
        });
    };
}
function countEventTypes(events) {
    return events.reduce(function (acc, event) {
        if (acc[event.event_type]) {
            acc[event.event_type] += 1;
        }
        else {
            acc[event.event_type] = 1;
        }
        return acc;
    }, {});
}
