var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/server/express/index.ts
var express_exports = {};
__export(express_exports, {
  A2AExpressApp: () => A2AExpressApp
});
module.exports = __toCommonJS(express_exports);

// src/server/express/a2a_express_app.ts
var import_express = __toESM(require("express"), 1);

// src/server/error.ts
var A2AError = class _A2AError extends Error {
  code;
  data;
  taskId;
  // Optional task ID context
  constructor(code, message, data, taskId) {
    super(message);
    this.name = "A2AError";
    this.code = code;
    this.data = data;
    this.taskId = taskId;
  }
  /**
   * Formats the error into a standard JSON-RPC error object structure.
   */
  toJSONRPCError() {
    const errorObject = {
      code: this.code,
      message: this.message
    };
    if (this.data !== void 0) {
      errorObject.data = this.data;
    }
    return errorObject;
  }
  // Static factory methods for common errors
  static parseError(message, data) {
    return new _A2AError(-32700, message, data);
  }
  static invalidRequest(message, data) {
    return new _A2AError(-32600, message, data);
  }
  static methodNotFound(method) {
    return new _A2AError(
      -32601,
      `Method not found: ${method}`
    );
  }
  static invalidParams(message, data) {
    return new _A2AError(-32602, message, data);
  }
  static internalError(message, data) {
    return new _A2AError(-32603, message, data);
  }
  static taskNotFound(taskId) {
    return new _A2AError(
      -32001,
      `Task not found: ${taskId}`,
      void 0,
      taskId
    );
  }
  static taskNotCancelable(taskId) {
    return new _A2AError(
      -32002,
      `Task not cancelable: ${taskId}`,
      void 0,
      taskId
    );
  }
  static pushNotificationNotSupported() {
    return new _A2AError(
      -32003,
      "Push Notification is not supported"
    );
  }
  static unsupportedOperation(operation) {
    return new _A2AError(
      -32004,
      `Unsupported operation: ${operation}`
    );
  }
  static authenticatedExtendedCardNotConfigured() {
    return new _A2AError(
      -32007,
      `Extended card not configured.`
    );
  }
};

// src/server/transports/jsonrpc_transport_handler.ts
var JsonRpcTransportHandler = class {
  requestHandler;
  constructor(requestHandler) {
    this.requestHandler = requestHandler;
  }
  /**
   * Handles an incoming JSON-RPC request.
   * For streaming methods, it returns an AsyncGenerator of JSONRPCResult.
   * For non-streaming methods, it returns a Promise of a single JSONRPCMessage (Result or ErrorResponse).
   */
  async handle(requestBody) {
    let rpcRequest;
    try {
      if (typeof requestBody === "string") {
        rpcRequest = JSON.parse(requestBody);
      } else if (typeof requestBody === "object" && requestBody !== null) {
        rpcRequest = requestBody;
      } else {
        throw A2AError.parseError("Invalid request body type.");
      }
      if (rpcRequest.jsonrpc !== "2.0" || !rpcRequest.method || typeof rpcRequest.method !== "string") {
        throw A2AError.invalidRequest(
          "Invalid JSON-RPC request structure."
        );
      }
    } catch (error) {
      const a2aError = error instanceof A2AError ? error : A2AError.parseError(error.message || "Failed to parse JSON request.");
      return {
        jsonrpc: "2.0",
        id: typeof rpcRequest?.id !== "undefined" ? rpcRequest.id : null,
        error: a2aError.toJSONRPCError()
      };
    }
    const { method, id: requestId = null } = rpcRequest;
    try {
      if (method === "agent/getAuthenticatedExtendedCard") {
        const result = await this.requestHandler.getAuthenticatedExtendedAgentCard();
        return {
          jsonrpc: "2.0",
          id: requestId,
          result
        };
      }
      if (!rpcRequest.params) {
        throw A2AError.invalidParams(`'params' is required for '${method}'`);
      }
      if (method === "message/stream" || method === "tasks/resubscribe") {
        const params = rpcRequest.params;
        const agentCard = await this.requestHandler.getAgentCard();
        if (!agentCard.capabilities.streaming) {
          throw A2AError.unsupportedOperation(`Method ${method} requires streaming capability.`);
        }
        const agentEventStream = method === "message/stream" ? this.requestHandler.sendMessageStream(params) : this.requestHandler.resubscribe(params);
        return async function* jsonRpcEventStream() {
          try {
            for await (const event of agentEventStream) {
              yield {
                jsonrpc: "2.0",
                id: requestId,
                // Use the original request ID for all streamed responses
                result: event
              };
            }
          } catch (streamError) {
            console.error(`Error in agent event stream for ${method} (request ${requestId}):`, streamError);
            throw streamError;
          }
        }();
      } else {
        let result;
        switch (method) {
          case "message/send":
            result = await this.requestHandler.sendMessage(rpcRequest.params);
            break;
          case "tasks/get":
            result = await this.requestHandler.getTask(rpcRequest.params);
            break;
          case "tasks/cancel":
            result = await this.requestHandler.cancelTask(rpcRequest.params);
            break;
          case "tasks/pushNotificationConfig/set":
            result = await this.requestHandler.setTaskPushNotificationConfig(
              rpcRequest.params
            );
            break;
          case "tasks/pushNotificationConfig/get":
            result = await this.requestHandler.getTaskPushNotificationConfig(
              rpcRequest.params
            );
            break;
          case "tasks/pushNotificationConfig/delete":
            await this.requestHandler.deleteTaskPushNotificationConfig(
              rpcRequest.params
            );
            result = null;
            break;
          case "tasks/pushNotificationConfig/list":
            result = await this.requestHandler.listTaskPushNotificationConfigs(
              rpcRequest.params
            );
            break;
          default:
            throw A2AError.methodNotFound(method);
        }
        return {
          jsonrpc: "2.0",
          id: requestId,
          result
        };
      }
    } catch (error) {
      const a2aError = error instanceof A2AError ? error : A2AError.internalError(error.message || "An unexpected error occurred.");
      return {
        jsonrpc: "2.0",
        id: requestId,
        error: a2aError.toJSONRPCError()
      };
    }
  }
};

// src/constants.ts
var AGENT_CARD_PATH = ".well-known/agent-card.json";

// src/server/express/a2a_express_app.ts
var A2AExpressApp = class {
  requestHandler;
  // Kept for getAgentCard
  jsonRpcTransportHandler;
  constructor(requestHandler) {
    this.requestHandler = requestHandler;
    this.jsonRpcTransportHandler = new JsonRpcTransportHandler(requestHandler);
  }
  /**
   * Adds A2A routes to an existing Express app.
   * @param app Optional existing Express app.
   * @param baseUrl The base URL for A2A endpoints (e.g., "/a2a/api").
   * @param middlewares Optional array of Express middlewares to apply to the A2A routes.
   * @param agentCardPath Optional custom path for the agent card endpoint (defaults to /.well-known/agent-card.json).
   * @returns The Express app with A2A routes.
   */
  setupRoutes(app, baseUrl = "", middlewares, agentCardPath = AGENT_CARD_PATH) {
    const router = import_express.default.Router();
    router.use(import_express.default.json(), ...middlewares ?? []);
    router.get(`/${agentCardPath}`, async (req, res) => {
      try {
        const agentCard = await this.requestHandler.getAgentCard();
        res.json(agentCard);
      } catch (error) {
        console.error("Error fetching agent card:", error);
        res.status(500).json({ error: "Failed to retrieve agent card" });
      }
    });
    router.post("/", async (req, res) => {
      try {
        const rpcResponseOrStream = await this.jsonRpcTransportHandler.handle(req.body);
        if (typeof rpcResponseOrStream?.[Symbol.asyncIterator] === "function") {
          const stream = rpcResponseOrStream;
          res.setHeader("Content-Type", "text/event-stream");
          res.setHeader("Cache-Control", "no-cache");
          res.setHeader("Connection", "keep-alive");
          res.flushHeaders();
          try {
            for await (const event of stream) {
              res.write(`id: ${(/* @__PURE__ */ new Date()).getTime()}
`);
              res.write(`data: ${JSON.stringify(event)}

`);
            }
          } catch (streamError) {
            console.error(`Error during SSE streaming (request ${req.body?.id}):`, streamError);
            const a2aError = streamError instanceof A2AError ? streamError : A2AError.internalError(streamError.message || "Streaming error.");
            const errorResponse = {
              jsonrpc: "2.0",
              id: req.body?.id || null,
              // Use original request ID if available
              error: a2aError.toJSONRPCError()
            };
            if (!res.headersSent) {
              res.status(500).json(errorResponse);
            } else {
              res.write(`id: ${(/* @__PURE__ */ new Date()).getTime()}
`);
              res.write(`event: error
`);
              res.write(`data: ${JSON.stringify(errorResponse)}

`);
            }
          } finally {
            if (!res.writableEnded) {
              res.end();
            }
          }
        } else {
          const rpcResponse = rpcResponseOrStream;
          res.status(200).json(rpcResponse);
        }
      } catch (error) {
        console.error("Unhandled error in A2AExpressApp POST handler:", error);
        const a2aError = error instanceof A2AError ? error : A2AError.internalError("General processing error.");
        const errorResponse = {
          jsonrpc: "2.0",
          id: req.body?.id || null,
          error: a2aError.toJSONRPCError()
        };
        if (!res.headersSent) {
          res.status(500).json(errorResponse);
        } else if (!res.writableEnded) {
          res.end();
        }
      }
    });
    app.use(baseUrl, router);
    return app;
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  A2AExpressApp
});
