"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConfigFromFiles = void 0;
exports.merge = merge;
exports.getPackageVersion = getPackageVersion;
// From https://github.com/elastic/kibana/blob/master/packages/kbn-config/src/raw/read_config.ts
var fs_1 = require("fs");
var js_yaml_1 = require("js-yaml");
var lodash_1 = require("lodash");
var ensure_deep_object_1 = require("./ensure_deep_object");
var readYaml = function (path) { return (0, js_yaml_1.load)((0, fs_1.readFileSync)(path, 'utf8')); };
function replaceEnvVarRefs(val) {
    return val.replace(/\$\{(\w+)\}/g, function (match, envVarName) {
        var envVarValue = process.env[envVarName];
        if (envVarValue !== undefined) {
            return envVarValue;
        }
        throw new Error("Unknown environment variable referenced in config : ".concat(envVarName));
    });
}
function merge(target, value, key) {
    var e_1, _a;
    if (((0, lodash_1.isPlainObject)(value) || Array.isArray(value)) &&
        Object.keys(value).length > 0) {
        try {
            for (var _b = __values(Object.entries(value)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = __read(_c.value, 2), subKey = _d[0], subVal = _d[1];
                merge(target, subVal, key ? "".concat(key, ".").concat(subKey) : subKey);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    else if (key !== undefined) {
        (0, lodash_1.set)(target, key, typeof value === 'string' ? replaceEnvVarRefs(value) : value);
    }
    return target;
}
/** @internal */
var getConfigFromFiles = function (configFiles) {
    var e_2, _a;
    var mergedYaml = {};
    try {
        for (var configFiles_1 = __values(configFiles), configFiles_1_1 = configFiles_1.next(); !configFiles_1_1.done; configFiles_1_1 = configFiles_1.next()) {
            var configFile = configFiles_1_1.value;
            var yaml = readYaml(configFile);
            if (yaml !== null) {
                mergedYaml = merge(mergedYaml, yaml);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (configFiles_1_1 && !configFiles_1_1.done && (_a = configFiles_1.return)) _a.call(configFiles_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return (0, ensure_deep_object_1.ensureDeepObject)(mergedYaml);
};
exports.getConfigFromFiles = getConfigFromFiles;
function getPackageVersion(packagePath) {
    try {
        var pkgStr = (0, fs_1.readFileSync)(packagePath, 'utf-8');
        var version = JSON.parse(pkgStr).version;
        if (version == undefined) {
            throw new Error('Version is undefined');
        }
        else {
            return version;
        }
    }
    catch (error) {
        throw new Error("Error loading package.json file from ".concat(packagePath));
    }
}
//# sourceMappingURL=read_config.js.map