"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerSslConfig = exports.serverSslSchema = void 0;
// Inspired by https://github.com/elastic/kibana/blob/master/src/core/server/http/ssl_config.ts
var crypto_1 = __importDefault(require("crypto"));
var joi_1 = __importDefault(require("joi"));
var ssl_config_1 = require("./ssl_config");
// `crypto` type definitions doesn't currently include `crypto.constants`, see
// https://github.com/DefinitelyTyped/DefinitelyTyped/blob/fa5baf1733f49cf26228a4e509914572c1b74adf/types/node/v6/index.d.ts#L3412
var cryptoConstants = crypto_1.default.constants;
var protocolMap = new Map([
    ['TLSv1', cryptoConstants.SSL_OP_NO_TLSv1],
    ['TLSv1.1', cryptoConstants.SSL_OP_NO_TLSv1_1],
    ['TLSv1.2', cryptoConstants.SSL_OP_NO_TLSv1_2],
]);
exports.serverSslSchema = ssl_config_1.baseSslSchema
    .keys({
    cipherSuites: joi_1.default.array()
        .items(joi_1.default.string())
        .default(cryptoConstants.defaultCoreCipherList.split(':')),
    enabled: joi_1.default.boolean().default(false),
    supportedProtocols: joi_1.default.array()
        .items(joi_1.default.string().valid('TLSv1', 'TLSv1.1', 'TLSv1.2'))
        .default(['TLSv1.1', 'TLSv1.2'])
        .min(1),
})
    .when('.enabled', {
    is: true,
    then: joi_1.default.object({ certificate: joi_1.default.required(), key: joi_1.default.required() }),
})
    .default();
var ServerSslConfig = /** @class */ (function (_super) {
    __extends(ServerSslConfig, _super);
    function ServerSslConfig(_a) {
        var key = _a.key, certificate = _a.certificate, keyPassphrase = _a.keyPassphrase, certificateAuthorities = _a.certificateAuthorities, enabled = _a.enabled, supportedProtocols = _a.supportedProtocols, cipherSuites = _a.cipherSuites;
        var _this = _super.call(this, { key: key, certificate: certificate, keyPassphrase: keyPassphrase, certificateAuthorities: certificateAuthorities }) || this;
        _this.enabled = enabled;
        _this.cipherSuites = cipherSuites;
        _this.supportedProtocols = supportedProtocols;
        return _this;
    }
    ServerSslConfig.prototype.getSecureOptions = function () {
        // our validation should ensure that this.supportedProtocols is at least an empty array,
        // which the following logic depends upon.
        if (this.supportedProtocols == null ||
            this.supportedProtocols.length === 0) {
            throw new Error("supportedProtocols should be specified");
        }
        var supportedProtocols = this.supportedProtocols;
        return Array.from(protocolMap).reduce(function (secureOptions, _a) {
            var _b = __read(_a, 2), protocolAlias = _b[0], secureOption = _b[1];
            // `secureOption` is the option that turns *off* support for a particular protocol,
            // so if protocol is supported, we should not enable this option.
            return supportedProtocols.includes(protocolAlias)
                ? secureOptions
                : secureOptions | secureOption; // eslint-disable-line no-bitwise
        }, 0);
    };
    return ServerSslConfig;
}(ssl_config_1.BaseSslConfig));
exports.ServerSslConfig = ServerSslConfig;
//# sourceMappingURL=server_ssl_config.js.map